<?php require '../../component/HeaderAdmin.php' ?>
<?php require '../../component/menupoa.php' ?>


<main class="app-main">
    <!--begin::App Content Header-->
    <div class="app-content-header">
        <!--begin::Container-->
        <div class="container-fluid">
            <!--begin::Row-->
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="mb-0">EMPLEADOS</h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-end">
                        <li class="breadcrumb-item"><a href="./dashboard.php">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Dashboard
                        </li>
                    </ol>
                </div>
            </div>
            <!--end::Row-->
        </div>
        <!--end::Container-->
    </div>
    <?php $iduserregion =  $_SESSION['id_region']; ?>
    <!--end::App Content Header-->
    <!--begin::App Content-->
    <div class="app-content">
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Datos Generales De Empleados.</h3>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="select-all"></th>
                                    <th>ID</th>
                                    <th>IMG PERFIL</th>
                                    <th>NOMBRE</th>
                                    <th>RFC</th>
                                    <th>ESTADO</th>
                                    <th>ROL</th>
                                    <th>REGIÓN</th>
                                    <th>PUESTO</th>
                                    <th>EMAIL</th>
                                    <th>ACCIONES</th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php

                                $consulta = mysqli_query($conexion, "SELECT te.id_empleado, te.id_empleado_externo, te.nombre_emp, te.user_rfc, te.password, 
               te.imgUser, te.estado, te.id_rol, tr.nom_rol, te.id_region, tg.nom_region, 
               te.id_puesto, tp.nom_puesto, te.email, te.fecha_registro 
        FROM tbl_empleados te
        JOIN tbl_rol tr ON tr.id_rol = te.id_rol
        JOIN tbl_region tg ON tg.id_region = te.id_region
        JOIN tbl_puesto tp ON tp.id_puesto = te.id_puesto
        WHERE te.id_region = $iduserregion  
        AND te.id_rol NOT IN (1, 4)
        ORDER BY te.fecha_registro DESC");
                                while ($row = mysqli_fetch_assoc($consulta)) {
                                ?>

                                <tr>
                                    <td>
                                        <!-- Checkbox para seleccionar usuarios -->
                                        <input type="checkbox" class="user-checkbox"
                                            value="<?php echo $row["id_empleado"]; ?>">
                                    </td>
                                    <td><?php echo $row["id_empleado"]; ?></td>
                                    <td class="text-center"><img
                                            src="<?php echo !empty($row['imgUser']) ? '../../../controllers/uploads/imgProfileUser/' . $row['imgUser'] : 'https://icones.pro/wp-content/uploads/2021/02/symbole-masculin-icone-l-utilisateur-gris.png'; ?>"
                                            class="user-image rounded-circle shadow" width="40px" alt="User Image"></td>
                                    <td><?php echo $row["nombre_emp"]; ?></td>
                                    <td><?php echo $row["user_rfc"]; ?></td>
                                    <td>
                                        <?php if ($row["estado"] != 'INACTIVO') { ?>
                                        <span class="badge bg-success float-center"><?php echo $row["estado"]; ?></span>

                                        <?php } else {  ?>
                                        <span class="badge bg-danger float-center"><?php echo $row["estado"]; ?></span>
                                        <?php }  ?>
                                    </td>
                                    <td><?php echo $row["nom_rol"]; ?></td>
                                    <td><?php echo $row["nom_region"]; ?></td>
                                    <td><?php echo $row["nom_puesto"]; ?></td>
                                    <td><?php echo $row["email"]; ?></td>
                                    <td>
                                        <button type="button" class="btn btn-primary btn-sm editarbtn"
                                            data-userIDexterno="<?php echo $row['id_empleado_externo']; ?>"
                                            data-nameuser="<?php echo $row['nombre_emp']; ?>"
                                            data-usuarioID="<?php echo $row['id_empleado']; ?>"
                                            data-userrfc="<?php echo $row["user_rfc"]; ?>"
                                            data-estado="<?php echo $row["estado"]; ?>"
                                            data-rolId="<?php echo $row["id_rol"]; ?>"
                                            data-regionId="<?php echo $row["id_region"]; ?>"
                                            data-puestoId="<?php echo $row["id_puesto"]; ?>"
                                            data-emailus="<?php echo $row["email"]; ?>">
                                            <i class="bi bi-pencil-square"></i> Editar
                                        </button>

                                    </td>
                                </tr>
                                <?php } ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th><input type="checkbox" id="select-all"></th>
                                    <th>ID</th>
                                    <th>IMG PERFIL</th>
                                    <th>NOMBRE</th>
                                    <th>RFC</th>
                                    <th>ESTADO</th>
                                    <th>ROL</th>
                                    <th>REGIÓN</th>
                                    <th>PUESTO</th>
                                    <th>EMAIL</th>
                                    <th>ACCIONES</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </section>
    </div>
    <!--end::App Content-->
</main>
<!--end::App Main-->
<!--begin::Footer-->



<!-- Modal ACTUALIZAR EMPLEADOS-->
<div class="modal fade" id="empleadoUpdateModal" tabindex="-1" aria-labelledby="empleadoUpdateModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <!-- Encabezado del Modal -->
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="empleadoUpdateModalLabel">
                    <i class="bi bi-person-badge me-2"></i>Actualizar Información Empleado
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                    aria-label="Close"></button>
            </div>

            <!-- Cuerpo del Modal -->
            <div class="modal-body">
                <form id="formEditarEmpleados" method="POST">
                    <div class="row">
                        <!-- Columna Izquierda -->
                        <div class="col-md-6">
                            <div class="card mb-3 shadow-sm">
                                <div class="card-header bg-light">
                                    <i class="bi bi-info-circle me-2"></i>Información Básica
                                </div>
                                <div class="card-body">
                                    <!-- ID Empleado Externo -->
                                    <div class="mb-3">
                                        <input type="hidden" id="usuarioIDupdate" name="usuarioIDupdate">
                                        <label for="id_empleado_externo" class="form-label">
                                            <i class="bi bi-card-heading me-2"></i>ID Empleado Externo
                                        </label>
                                        <input type="text" class="form-control" id="id_empleado_externo_update"
                                            name="id_empleado_externo_update" required readonly>
                                    </div>

                                    <!-- Nombre del Empleado -->
                                    <div class="mb-3">
                                        <label for="nombre_emp" class="form-label">
                                            <i class="bi bi-person me-2"></i>Nombre del Empleado
                                        </label>
                                        <input type="text" class="form-control" id="nombre_emp_update"
                                            name="nombre_emp_update" required readonly>
                                    </div>

                                    <!-- RFC -->
                                    <div class="mb-3">
                                        <label for="user_rfc" class="form-label">
                                            <i class="bi bi-file-earmark-text me-2"></i>RFC
                                        </label>
                                        <input type="text" class="form-control" id="user_rfc_update"
                                            name="user_rfc_update" required readonly>
                                        <small class="form-text text-muted">Formato: 4 letras, 6 dígitos y 3 caracteres
                                            alfanuméricos.</small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Columna Derecha -->
                        <div class="col-md-6">
                            <div class="card mb-3 shadow-sm">
                                <div class="card-header bg-light">
                                    <i class="bi bi-gear me-2"></i>Configuración Adicional
                                </div>
                                <div class="card-body">
                                    <!-- Contraseña -->
                                    <div class="mb-3">
                                        <label for="password" class="form-label">
                                            <i class="bi bi-lock me-2"></i>Contraseña
                                        </label>
                                        <input type="password" class="form-control" id="contraseña_usu"
                                            name="contraseña_usu" minlength="8">
                                    </div>

                                    <div class="mb-3">
                                        <label for="password" class="form-label">
                                            <i class="bi bi-lock me-2"></i>Confirma Contraseña
                                        </label>
                                        <input type="password" class="form-control" id="confirmar_contraseña_usu"
                                            name="confirmar_contraseña_usu" minlength="8">
                                    </div>
                                    <p id="errorMensajeupdate" style="color: red; display: none;">Las contraseñas no
                                        coinciden.</p>
                                    <!-- Estado -->
                                    <div class="mb-3">
                                        <label for="estado" class="form-label">
                                            <i class="bi bi-toggle-on me-2"></i>Estado
                                        </label>
                                        <select class="form-select" id="estadoupdate" name="estadoupdate" required
                                            disabled>
                                            <option value="ACTIVO">ACTIVO</option>
                                            <option value="INACTIVO">INACTIVO</option>
                                        </select>
                                    </div>

                                    <!-- ID Rol -->
                                    <div class="mb-3">
                                        <label for="id_rol" class="form-label">
                                            <i class="bi bi-person-badge me-2"></i>Rol
                                        </label>
                                        <select class="form-select" id="id_rol_update" name="id_rol_update" required
                                            disabled>
                                            <option value="" disabled>Seleccione Rol</option>
                                            <?php
                                            $consulta = mysqli_query($conexion, "SELECT id_rol, nom_rol  FROM tbl_rol;");
                                            while ($row = mysqli_fetch_assoc($consulta)) {
                                                echo "<option value='" . $row['id_rol'] . "'>" . $row['nom_rol'] . "</option>"
                                            ?>

                                            <?php } ?>
                                        </select>
                                    </div>

                                    <!-- ID Región -->
                                    <div class="mb-3">
                                        <label for="id_region" class="form-label">
                                            <i class="bi bi-globe me-2"></i>Región
                                        </label>
                                        <select class="form-select" id="id_region_update" name="id_region_update"
                                            required disabled>
                                            <option value="" disabled>Región</option>
                                            <?php
                                            $consulta = mysqli_query($conexion, "SELECT id_region , nom_region  FROM tbl_region;");
                                            while ($row = mysqli_fetch_assoc($consulta)) {
                                                echo "<option value='" . $row['id_region'] . "'>" . $row['nom_region'] . "</option>"
                                            ?>
                                            <?php } ?>
                                        </select>
                                    </div>

                                    <!-- ID Puesto -->
                                    <div class="mb-3">
                                        <label for="id_puesto" class="form-label">
                                            <i class="bi bi-briefcase me-2"></i>Puesto
                                        </label>
                                        <select class="form-select" id="id_puesto_update" name="id_puesto_update"
                                            required disabled>
                                            <option value="" disabled>Seleccione Rol</option>
                                            <?php
                                            $consulta = mysqli_query($conexion, "SELECT id_puesto , nom_puesto  FROM tbl_puesto;");
                                            while ($row = mysqli_fetch_assoc($consulta)) {
                                                echo "<option value='" . $row['id_puesto'] . "'>" . $row['nom_puesto'] . "</option>"
                                            ?>

                                            <?php } ?>
                                        </select>
                                    </div>

                                    <!-- Email -->
                                    <div class="mb-3">
                                        <label for="email" class="form-label">
                                            <i class="bi bi-envelope me-2"></i>Email
                                        </label>
                                        <input type="email" class="form-control" id="emailupdate" name="emailupdate"
                                            required readonly>
                                    </div>

                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="admin-password-group" style="display:none">
                            <div class="card mb-0 shadow-sm">
                                <div class="card-header bg-light">
                                    <i class="bi bi-info-circle me-2"></i>Inserta Contraseña Administrador
                                </div>
                                <div class="card-body">
                                    <!-- Campo de Contraseña Actual del Administrador -->
                                    <div class="form-group mb-3">
                                        <label for="admin_contraseña" class="form-label">Contraseña Actual del
                                            Administrador:</label>
                                        <input type="password" name="admin_contraseña" class="form-control"
                                            placeholder="Ingresa tu contraseña actual">
                                        <small class="form-text text-muted">Para actualizar la contraseña, ingrese la
                                            contraseña del administrador.</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Pie del Modal -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="bi bi-x-circle me-2"></i>Cancelar
                        </button>
                        <button type="submit" class="btn btn-primary btnUpdateUser" id="btnUpdateUser">
                            <i class="bi bi-save me-2"></i>Guardar
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>




<script>
//script para mostrar los datos en el modal de editar
document.addEventListener("DOMContentLoaded", function() {
    // Detectamos clics en cualquier parte del documento
    document.addEventListener("click", function(event) {
        // Verificamos si el clic fue en un botón de edición
        if (event.target.closest(".editarbtn")) {
            let boton = event.target.closest(".editarbtn");

            // Obtener referencias a los campos del modal
            let modal = document.getElementById("empleadoUpdateModal");

            // Llenar los campos con los atributos del botón

            modal.querySelector("#id_empleado_externo_update").value = boton.getAttribute(
                "data-userIDexterno");
            modal.querySelector("#nombre_emp_update").value = boton.getAttribute("data-nameuser");
            modal.querySelector("#usuarioIDupdate").value = boton.getAttribute("data-usuarioID");
            modal.querySelector("#user_rfc_update").value = boton.getAttribute("data-userrfc");
            modal.querySelector("#estadoupdate").value = boton.getAttribute("data-estado");
            modal.querySelector("#id_rol_update").value = boton.getAttribute("data-rolId");
            modal.querySelector("#id_region_update").value = boton.getAttribute("data-regionId");
            modal.querySelector("#id_puesto_update").value = boton.getAttribute("data-puestoId");
            modal.querySelector("#emailupdate").value = boton.getAttribute("data-emailus");



            // Mostrar el modal
            let modalInstance = new bootstrap.Modal(modal);
            modalInstance.show();
        }
    });
});


///ACTUALIZACION DE USUARIOS
document.addEventListener("DOMContentLoaded", function() {
    const formEditarEmpleados = document.getElementById("formEditarEmpleados");
    const adminPasswordGroup = document.getElementById("admin-password-group");
    const passwordInput = document.getElementById("contraseña_usu");
    const confirmPasswordInput = document.getElementById("confirmar_contraseña_usu");
    const errorMensaje = document.getElementById("errorMensajeupdate");

    // Detectar si se quiere cambiar la contraseña y mostrar el campo de admin
    passwordInput.addEventListener("input", function() {
        adminPasswordGroup.style.display = passwordInput.value.trim() !== "" ? "block" : "none";
    });

    // Validar si las contraseñas coinciden
    function validarPassword() {
        const password = passwordInput.value.trim();
        const confirmPassword = confirmPasswordInput.value.trim();

        if (password === "" || confirmPassword === "") {
            errorMensaje.style.display = "none"; // Ocultar el mensaje si están vacíos
            return;
        }

        if (password !== confirmPassword) {
            errorMensaje.style.display = "block";
            errorMensaje.textContent = "Las contraseñas no coinciden.";
        } else {
            errorMensaje.style.display = "none";
        }
    }

    // Agregar eventos de validación a los campos de contraseña
    passwordInput.addEventListener("input", validarPassword);
    confirmPasswordInput.addEventListener("input", validarPassword);

    // Manejo del envío del formulario
    formEditarEmpleados.addEventListener("submit", function(e) {
        e.preventDefault(); // Prevenir el envío del formulario

        // Validar que las contraseñas coincidan antes de enviar
        if (passwordInput.value.trim() !== "" && passwordInput.value !== confirmPasswordInput.value) {
            Swal.fire({
                icon: "error",
                title: "Error",
                text: "Las contraseñas que deseas actualizar no coinciden.",
            });
            return;
        }

        // Crear objeto con los datos del formulario
        const formData = new FormData(formEditarEmpleados);

        // Enviar los datos con Fetch
        fetch("../../../controllers/actualizarEmpleadosController.php", {
                method: "POST",
                body: formData
            })
            .then(response => response.json()) // Intentar parsear la respuesta a JSON
            .then(data => {
                if (typeof data !== "object" || !data.status) {
                    throw new Error("La respuesta del servidor no es válida.");
                }

                if (data.status === "success") {
                    Swal.fire({
                        icon: "success",
                        title: "Usuario actualizado",
                        text: data.message,
                    }).then(() => {
                        $('#modal_actualizar_usuario').modal('hide');
                        location.reload();
                    });
                } else {
                    Swal.fire({
                        icon: "error",
                        title: "Error",
                        text: data.message,
                    });
                }
            })
            .catch(error => {
                console.error("Error en la actualización:", error);
                Swal.fire({
                    icon: "error",
                    title: "Error de conexión",
                    text: "Hubo un problema al conectar con el servidor. Inténtalo de nuevo.",
                });
            });
    });
});
</script>

<?php require '../../component/FooterAdmin.php' ?>