<?php require '../../component/HeaderAdmin.php' ?>
<?php require '../../component/menuEmpleado.php'  ?>


<main class="app-main">
    <!--begin::App Content Header-->
    <div class="app-content-header">
        <!--begin::Container-->
        <div class="container-fluid">
            <!--begin::Row-->
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="mb-0">
                        <?php echo  $_SESSION["rfc"] . ' - ' . $_SESSION["nombre"]; ?></h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-end">
                        <li class="breadcrumb-item"><a href="./dashboard.php">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Dashboard
                        </li>
                    </ol>
                </div>
            </div>
            <!--end::Row-->
        </div>
        <!--end::Container-->
    </div>
    <!--end::App Content Header-->
    <!--begin::App Content-->
    <div class="app-content">
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Datos Generales y Recibo de Nominas</h3>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">

                        <?php
                        $useID = $_SESSION["id"];
                        $consulta = mysqli_query($conexion, "SELECT ta.id_archivo, te.id_empleado, te.imgUser, te.nombre_emp, te.user_rfc, te.estado, tr.nom_rol, tg.nom_region, tp.nom_puesto, ta.nombre_archivo, ta.ruta_archivo, ta.fechaPago FROM tbl_archivos ta JOIN tbl_empleados te ON te.id_empleado = ta.id_empleado JOIN tbl_rol tr ON tr.id_rol = te.id_rol JOIN tbl_region tg ON tg.id_region = te.id_region JOIN tbl_puesto tp ON tp.id_puesto = te.id_puesto WHERE te.id_empleado = $useID ORDER BY ta.fechaPago DESC, ta.id_archivo ASC;");

                        // Arreglo para agrupar archivos por fechaPago
                        $archivos_por_fecha = [];

                        while ($row = mysqli_fetch_assoc($consulta)) {
                            $fechaPago = $row["fechaPago"];
                            if (!isset($archivos_por_fecha[$fechaPago])) {
                                $archivos_por_fecha[$fechaPago] = []; // Inicializa el arreglo para la fecha
                            }
                            $archivos_por_fecha[$fechaPago][] = $row; // Agrega el archivo al arreglo de la fecha
                        }
                        ?>

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>IMG PERFIL</th>
                                    <th>NOMBRE</th>
                                    <th>RFC</th>
                                    <th>ESTADO</th>
                                    <th>REGIÓN</th>
                                    <th>PUESTO</th>
                                    <th>CFDI</th>
                                    <th>FECHA PAGO</th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($archivos_por_fecha as $fechaPago => $archivos) { ?>
                                    <tr>
                                        <td><?php echo $archivos[0]["id_archivo"]; ?></td>
                                        <td class="text-center">
                                            <img src="<?php echo !empty($archivos[0]['imgUser']) ? '../../../controllers/uploads/imgProfileUser/' . $archivos[0]['imgUser'] : 'https://icones.pro/wp-content/uploads/2021/02/symbole-masculin-icone-l-utilisateur-gris.png'; ?>"
                                                class="user-image rounded-circle shadow" width="40px" alt="User Image">
                                        </td>
                                        <td><?php echo $archivos[0]["nombre_emp"]; ?></td>
                                        <td><?php echo $archivos[0]["user_rfc"]; ?></td>
                                        <td>
                                            <?php if ($archivos[0]["estado"] != 'INACTIVO') { ?>
                                                <span
                                                    class="badge bg-success float-center"><?php echo $archivos[0]["estado"]; ?></span>
                                            <?php } else { ?>
                                                <span
                                                    class="badge bg-danger float-center"><?php echo $archivos[0]["estado"]; ?></span>
                                            <?php } ?>
                                        </td>
                                        <td><?php echo $archivos[0]["nom_region"]; ?></td>
                                        <td><?php echo $archivos[0]["nom_puesto"]; ?></td>
                                        <td>
                                            <?php foreach ($archivos as $row) { ?>
                                                <a href="../../../controllers/<?php echo $row["ruta_archivo"]; ?>" download>
                                                    <?php echo $row["nombre_archivo"]; ?>
                                                </a><br>
                                            <?php } ?>
                                        </td>
                                        <td><?php echo $fechaPago; ?></td>

                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </section>
    </div>
    <!--end::App Content-->
</main>
<!--end::App Main-->
<!--begin::Footer-->








<?php require '../../component/FooterAdmin.php' ?>