<?php require '../../component/HeaderAdmin.php' ?>
<?php require '../../component/menucg.php'  ?>


<main class="app-main">
    <!--begin::App Content Header-->
    <div class="app-content-header">
        <!--begin::Container-->
        <div class="container-fluid">
            <!--begin::Row-->
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="mb-0">AGREGAR CFDI</h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-end">
                        <li class="breadcrumb-item"><a href="./dashboard.php">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Dashboard
                        </li>
                    </ol>
                </div>
            </div>
            <!--end::Row-->
        </div>
        <!--end::Container-->
    </div>
    <!--end::App Content Header-->
    <!--begin::App Content-->
    <div class="app-content">
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Datos Generales y Recibo de Nominas</h3>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">






                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>IMG PERFIL</th>
                                    <th>NOMBRE</th>
                                    <th>RFC</th>
                                    <th>ESTADO</th>
                                    <th>ROL</th>
                                    <th>REGIÓN</th>
                                    <th>PUESTO</th>
                                    <th>DOCUMENTOS</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $consulta = mysqli_query($conexion, "SELECT 
    te.id_empleado, 
    te.imgUser, 
    te.nombre_emp, 
    te.user_rfc, 
    te.estado, 
    tr.nom_rol, 
    tg.nom_region, 
    tp.nom_puesto
FROM tbl_empleados te
LEFT JOIN tbl_archivos ta ON te.id_empleado = ta.id_empleado
JOIN tbl_rol tr ON tr.id_rol = te.id_rol
JOIN tbl_region tg ON tg.id_region = te.id_region
JOIN tbl_puesto tp ON tp.id_puesto = te.id_puesto
WHERE te.id_rol NOT IN (1, 4)
GROUP BY te.id_empleado, te.imgUser, te.nombre_emp, te.user_rfc, te.estado, tr.nom_rol, tg.nom_region, tp.nom_puesto
ORDER BY MAX(ta.fechaPago) DESC;");

                                while ($row = mysqli_fetch_assoc($consulta)) {
                                    $total_archivos = $row['total_archivos'];
                                    $faltantes = 4 - $total_archivos;
                                ?>
                                <tr>
                                    <td><?php echo $row["id_empleado"]; ?></td>
                                    <td class="text-center">
                                        <img src="<?php echo !empty($row['imgUser']) ? '../../../controllers/uploads/imgProfileUser/' . $row['imgUser'] : 'https://icones.pro/wp-content/uploads/2021/02/symbole-masculin-icone-l-utilisateur-gris.png'; ?>"
                                            class="user-image rounded-circle shadow" width="40px" alt="User Image">
                                    </td>
                                    <td><?php echo $row["nombre_emp"]; ?></td>
                                    <td><?php echo $row["user_rfc"]; ?></td>
                                    <td>
                                        <span
                                            class="badge <?php echo ($row["estado"] != 'INACTIVO') ? 'bg-success' : 'bg-danger'; ?>">
                                            <?php echo $row["estado"]; ?>
                                        </span>
                                    </td>
                                    <td><?php echo $row["nom_rol"]; ?></td>
                                    <td><?php echo $row["nom_region"]; ?></td>
                                    <td><?php echo $row["nom_puesto"]; ?></td>
                                    <!-- Añadir un botón en la columna DOCUMENTOS -->
                                    <td>
                                        <button type="button" class="btn btn-outline-primary btn-sm position-relative"
                                            data-bs-toggle="modal" data-bs-target="#modalDocumentos"
                                            data-id-empleado="<?php echo $row['id_empleado']; ?>"
                                            title="Ver documentos adjuntos">
                                            <i class="bi bi-file-earmark-richtext me-1"></i> Ver Documentos

                                        </button>
                                    </td>




                                </tr>
                                <?php } ?>
                            </tbody>

                            <tfoot>

                                <tr>
                                    <th>ID</th>
                                    <th>IMG PERFIL</th>
                                    <th>NOMBRE</th>
                                    <th>RFC</th>
                                    <th>ESTADO</th>
                                    <th>ROL</th>
                                    <th>REGIÓN</th>
                                    <th>PUESTO</th>
                                    <th>DOCUMENTOS</th>


                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </section>
    </div>
    <!--end::App Content-->
</main>
<!--end::App Main-->
<!--begin::Footer-->

<!-- Modal para mostrar documentos -->
<div class="modal fade" id="modalDocumentos" tabindex="-1" aria-labelledby="modalDocumentosLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalDocumentosLabel">Documentos del Empleado</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <!-- DataTable para mostrar documentos -->
                <table id="dataTableDocumentos" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Nombre Archivo</th>
                            <th>Fecha de Pago</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Los documentos se cargarán aquí con AJAX -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>


<script>
$('#modalDocumentos').on('show.bs.modal', function(e) {
    var idEmpleado = $(e.relatedTarget).data('id-empleado'); // Obtener el ID del empleado
    var modal = $(this);

    // Destruir la instancia anterior del DataTable si ya existe
    if ($.fn.DataTable.isDataTable('#dataTableDocumentos')) {
        $('#dataTableDocumentos').DataTable().clear().destroy();
    }

    // Inicializar DataTable solo si aún no está inicializado
    $('#dataTableDocumentos').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "../../../controllers/obtenerDocumentosControllerUsuario.php", // El archivo PHP que maneja la consulta AJAX
            "type": "GET",
            "data": {
                "id_empleado": idEmpleado // Pasar el ID del empleado al backend
            },
            "dataSrc": function(json) {
                // Aquí puedes procesar los datos si es necesario
                return json.data;
            }
        },
        "columns": [{
                "data": "nombre_archivo"
            },
            {
                "data": "fechaPago"
            },
            {
                "data": "ruta_archivo",
                "render": function(data, type, row) {
                    return '<a href="../../../controllers/' + data +
                        '" download><i class="bi bi-download"></i> Descargar</a>';
                }
            }
        ],
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "No hay datos disponibles",
            "sInfo": "Mostrando _START_ a _END_ de _TOTAL_ registros",
            "sInfoEmpty": "Mostrando 0 a 0 de 0 registros",
            "sInfoFiltered": "(filtrado de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sPrevious": "Anterior",
                "sNext": "Siguiente",
                "sLast": "Último"
            }
        },
        "paging": true, // Habilitar la paginación
        "pageLength": 10, // Número de registros por página
        "lengthChange": true, // Opción para cambiar el número de registros por página
        "info": true, // Muestra la información de la paginación
        "autoWidth": false
    });
});
</script>

<?php require '../../component/FooterAdmin.php' ?>