<?php require '../../component/HeaderAdmin.php' ?>
<?php require '../../component/menuAdmin.php'  ?>

<style>
/* Opcional: Estilo para el contenedor de resultados */
.result-item {
    padding: 10px;
    border: 1px solid #ddd;
    margin-bottom: 5px;
    cursor: pointer;
    background-color: #f8f9fa;
}

.result-item:hover {
    background-color: #e9ecef;
}

#results {
    display: none;
    /* Ocultar inicialmente */
    max-height: 200px;
    overflow-y: auto;
    border: 1px solid #ccc;
    background-color: #fff;
}
</style>

<main class="app-main">
    <!--begin::App Content Header-->
    <div class="app-content-header">
        <!--begin::Container-->
        <div class="container-fluid">
            <!--begin::Row-->
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="mb-0">GESTIÓN DOCUMENTOS</h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-end">
                        <li class="breadcrumb-item"><a href="./dashboard.php">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Dashboard
                        </li>
                    </ol>
                </div>
            </div>
            <!--end::Row-->
        </div>
        <!--end::Container-->
    </div>
    <!--end::App Content Header-->
    <!--begin::App Content-->
    <div class="app-content">
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Gestión de Documentos del Personal.</h3>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        <button class="btn btn-warning mb-3 btn-block" style="font-size: 1.25rem; font-weight: bold;"
                            data-bs-toggle="modal" data-bs-target="#modalSubirDocsUsu"> AGREGAR DOCUMENTOS </button>





                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>

                                    <th>ID</th>
                                    <th>IMG PERFIL</th>
                                    <th>NOMBRE</th>
                                    <th>RFC</th>
                                    <th>ESTADO</th>
                                    <th>REGIÓN</th>
                                    <th>PUESTO</th>
                                    <th>EMAIL</th>
                                    <th>CONTRATOS</th>
                                    <th>AFILES</th>
                                    <th>BAJAS</th>
                                    <th>ACCIONES</th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php

                                $consulta = mysqli_query($conexion, "SELECT 
    tdc.id, 
    te.imgUser,
    tdc.id_empleado,
    te.id_region,
    te.nombre_emp,
    te.estado,
    te.user_rfc, 
    tr.nom_rol, 
    trg.nom_region, 
    tp.nom_puesto,
    te.email, 
    tdc.contrato, 
    tdc.afiliacion, 
    tdc.baja 
FROM 
    tbl_doc_empl tdc 
    INNER JOIN tbl_empleados te FORCE INDEX (PRIMARY) ON te.id_empleado = tdc.id_empleado 
    INNER JOIN tbl_rol tr ON tr.id_rol = te.id_rol 
    INNER JOIN tbl_region trg ON trg.id_region = te.id_region 
    INNER JOIN tbl_puesto tp ON tp.id_puesto = te.id_puesto
ORDER BY 
    te.nombre_emp ASC;");
                                while ($row = mysqli_fetch_assoc($consulta)) {
                                ?>

                                <tr>
                                    <td><?php echo $row["id"]; ?></td>
                                    <td class="text-center"><img
                                            src="<?php echo !empty($row['imgUser']) ? '../../../controllers/uploads/imgProfileUser/' . $row['imgUser'] : 'https://icones.pro/wp-content/uploads/2021/02/symbole-masculin-icone-l-utilisateur-gris.png'; ?>"
                                            class="user-image rounded-circle shadow" width="40px" alt="User Image"></td>
                                    <td><?php echo $row["nombre_emp"]; ?></td>
                                    <td><?php echo $row["user_rfc"]; ?></td>
                                    <td>
                                        <?php if ($row["estado"] != 'INACTIVO') { ?>
                                        <span class="badge bg-success float-center"><?php echo $row["estado"]; ?></span>

                                        <?php } else {  ?>
                                        <span class="badge bg-danger float-center"><?php echo $row["estado"]; ?></span>
                                        <?php }  ?>
                                    </td>
                                    <td><?php echo $row["nom_region"]; ?></td>
                                    <td><?php echo $row["nom_puesto"]; ?></td>
                                    <td><?php echo $row["email"]; ?></td>
                                    <td>
                                        <?php if (!empty($row["contrato"])) { ?>
                                        <a href="../../<?php echo $row["contrato"]  ?>" target="_blank">
                                            <i class="bi bi-file-earmark-text fs-4"></i>
                                        </a>
                                        <?php } else {
                                                echo "<span class='d-inline-block bg-light text-muted rounded-pill px-3 py-1 mb-1'>
  <i class='bi bi-slash-circle me-1'></i>
  <small>Documento no disponible</small>
</span>";
                                            } ?>
                                    </td>
                                    <td>
                                        <?php if (!empty($row["afiliacion"])) { ?>
                                        <a href="../../<?php echo $row["afiliacion"]  ?>" target="_blank">
                                            <i class="bi bi-file-earmark-text fs-4"></i>
                                        </a>
                                        <?php } else {
                                                echo "<span class='d-inline-block bg-light text-muted rounded-pill px-3 py-1 mb-1'>
  <i class='bi bi-slash-circle me-1'></i>
  <small>Documento no disponible</small>
</span>";
                                            } ?>
                                    </td>
                                    <td>
                                        <?php if (!empty($row["baja"])) { ?>
                                        <a href="../../<?php echo $row["baja"]  ?>" target="_blank">
                                            <i class="bi bi-file-earmark-text fs-4"></i>
                                        </a>
                                        <?php } else {
                                                echo "<span class='d-inline-block bg-light text-muted rounded-pill px-3 py-1 mb-1'>
  <i class='bi bi-slash-circle me-1'></i>
  <small>Documento no disponible</small>
</span>";
                                            } ?>
                                    </td>
                                    <td>
                                        <div class="d-flex gap-1 flex-nowrap">
                                            <button type="button"
                                                class="btn btn-primary btn-sm py-1 px-2 text-nowrap actualizarDocs"
                                                data-iddoc="<?php echo $row["id"]; ?>"
                                                data-idus="<?php echo $row["id_empleado"]; ?>"
                                                data-idre="<?php echo $row["id_region"]; ?>"
                                                data-nameusu="<?php echo $row["nombre_emp"]; ?>"
                                                data-contrato="<?php echo $row["contrato"] ?>"
                                                data-afiliacion="<?php echo $row["afiliacion"] ?>"
                                                data-baja="<?php echo $row["baja"] ?>">
                                                <i class="bi bi-pencil-square"></i> <span
                                                    class="d-none d-sm-inline">Editar</span>
                                            </button>

                                        </div>
                                    </td>
                                </tr>
                                <?php } ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>ID</th>
                                    <th>IMG PERFIL</th>
                                    <th>NOMBRE</th>
                                    <th>RFC</th>
                                    <th>ESTADO</th>
                                    <th>REGIÓN</th>
                                    <th>PUESTO</th>
                                    <th>EMAIL</th>
                                    <th>CONTRATOS</th>
                                    <th>AFILES</th>
                                    <th>BAJAS</th>
                                    <th>ACCIONES</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </section>
    </div>
    <!--end::App Content-->
</main>
<!--end::App Main-->
<!--begin::Footer-->

<!-- Modal para subir documentos -->

<div class="modal fade" id="modalSubirDocsUsu" tabindex="-1" aria-labelledby="modalSubirDocsUsuLabel"
    aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="modalSubirDocsUsuLabel">
                    <i class="bi bi-file-earmark-pdf"></i> Subir Documentos PDF
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <div class="modal-body">
                <form id="formSubirDocs" enctype="multipart/form-data">
                    <!-- Selección de Usuario -->
                    <div class="mb-3">
                        <label for="nombre">Seleccione Usuario</label>
                        <input type="text" id="searchInput" class="form-control mb-3" placeholder="Buscar..." autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="false">
                        <input type="hidden" id="searchInputID" name="searchInputID">
                        <input type="hidden" id="searchInputIDRegion" name="searchInputIDRegion">
                        <div id="results"></div>
                    </div>
                    <div class="mb-3">
                        <label for="contrato" class="form-label">Contrato (PDF)</label>
                        <input type="file" class="form-control" id="contrato" name="contrato" accept=".pdf">
                    </div>

                    <div class="mb-3">
                        <label for="afiliacion" class="form-label">Afiliación (PDF)</label>
                        <input type="file" class="form-control" id="afiliacion" name="afiliacion" accept=".pdf">
                    </div>

                    <div class="mb-3">
                        <label for="baja" class="form-label">Baja (PDF)</label>
                        <input type="file" class="form-control" id="baja" name="baja" accept=".pdf">
                    </div>

                    <!-- Vista previa de archivos -->
                    <div id="filePreview" class="mt-3"></div>

                    <!-- Botón de subida -->
                    <button type="submit" class="btn btn-success w-100 mt-3">
                        <i class="bi bi-cloud-upload"></i> Subir Documentos
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>








<!-- Modal Actualizar -->
<div class="modal fade" id="modalActualizarDocs" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Actualizar Documentos De: <span id="usunametitle"></span> </h5>

                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="formActualizarDocs" enctype="multipart/form-data">
                    <input type="hidden" name="update_id_document" id="update_id_document">
                    <input type="hidden" name="update_id_usuario" id="update_id_usuario">



                    <div class="mb-3">
                        <label class="form-label">Contrato actual:</label>
                        <ul class="list-group mt-2">
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <i class="bi bi-file-earmark-pdf text-danger"></i>
                                <div id="contrato-current" class="form-text"></div>

                            </li>
                            <input type="file" class="form-control" name="contrato" id="new-contrato">

                        </ul>
                        <ul class="list-group mt-2">
                            <label class="form-label">Afiliación actual:</label>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <i class="bi bi-file-earmark-pdf text-danger"></i>
                                <div id="afiliacion-current" class="form-text"></div>

                            </li>
                            <input type="file" class="form-control" name="afiliacion" id="new-afiliacion">

                        </ul>
                        <ul class="list-group mt-2">
                            <label class="form-label">Baja actual:</label>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <i class="bi bi-file-earmark-pdf text-danger"></i>
                                <div id="baja-current" class="form-text"></div>

                            </li>
                            <input type="file" class="form-control" name="baja" id="new-baja">
                        </ul>
                    </div>



                    <div class="mt-3">
                        <button type="submit" class="btn btn-success">Actualizar</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>







<script>
//SCRIPT PARA LA BUSQUEDA DE USUARIOS.
$(document).ready(function() {
    // Evento de clic para mostrar resultados
    $('#searchInput').on('focus', function() {
        $('#results').fadeIn(); // Mostrar el contenedorsultados

        // Realizar la búsqueda cuando el input recibe foco (mostrar todos los resultados si el input está vacío)
        const query = $(this).val(); // Tomar el valor actual del input

        // Si el campo está vacío, mostrar todos los resultados
        if (query === '') {
            fetchResults('');
        }
    });

    // Evento de búsqueda en tiempo real
    $('#searchInput').on('keyup', function() {
        const query = $(this).val();

        // Llamada AJAX al servidor
        fetchResults(query);
    });

    // Función para hacer la llamada AJAX y actualizar los resultados
    function fetchResults(query) {
        $.ajax({
            url: '../../../controllers/searchUsuariosController.php', // Archivo PHP que maneja la búsqueda
            method: 'GET',
            data: {
                q: query
            }, // Enviar término de búsqueda
            dataType: 'json',
            success: function(data) {
                //console.log(data);
                let resultsHTML = '';

                if (data.length > 0) {
                    data.forEach(item => {
                        resultsHTML += `
                            <div class="result-item" data-id="${item.id_empleado}" data-name="${item.nombre_emp}" data-regionid="${item.id_region}">
                                <strong>${item.nombre_emp}</strong><br>
                                <small>${item.user_rfc}</small>
                                <small>${item.id_region}</small>
                            </div>
                        `;
                    });
                } else {
                    resultsHTML =
                        '<p class="text-muted px-2">No se encontraron resultados</p>';
                }

                $('#results').html(resultsHTML);
            },
            error: function(xhr, status, error) {
                console.error("Error:", error);
                $('#results').html(
                    `<p class="text-danger px-2">Error al buscar datos: ${error}</p>`
                );
            }
        });
    }

    // Ocultar resultados al hacer clic en un resultado
    $(document).on("click", ".result-item", function() {
        const id = $(this).data("id");
        const name = $(this).data("name");
        const regionID = $(this).data("regionid")
        const nombrecompleto = name;
        $("#searchInputIDRegion").val(regionID);
        $("#searchInput").val(nombrecompleto); // Poner el id en el input
        $("#searchInputID").val(id); // Poner el id en el input
        $("#results").fadeOut(); // Ocultar los resultados
    });

    // Ocultar resultados al hacer clic fuera del input
    $(document).on('click', function(e) {
        if (!$(e.target).closest('#searchInput, #results').length) {
            $('#results').fadeOut();
        }
    });
});






// Archivo: script.js (AJAX para el formulario)
$(document).ready(function() {
    $('#formSubirDocs').submit(function(e) {
        e.preventDefault();
        let formData = new FormData(this);
        $.ajax({
            url: '../../../controllers/cargaArchivosUsuariosController.php',
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            dataType: 'json',
            success: function(response) {
                Swal.fire({
                    icon: response.status,
                    title: response.status === 'success' ? '¡Éxito!' : 'Atención',
                    text: response.message,
                }).then(() => {
                    if (response.status === 'success') {
                        $('#formSubirDocs')[0].reset();
                        $('#modalSubirDocsUsu').modal('hide');
                        location.reload();

                    }

                });

            },
            error: function() {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Ocurrió un problema inesperado.'
                });
            }
        });
    });
});


//SCRIPT PARA ACTUALIZAR LOS DATOS
// Cargar datos al modal
// $(".actualizarDocs").click(function() {
//     let id = $(this).data("iddoc");
//     let update_id_usuario = $(this).data("idus");
//     let nameusu = $(this).data("nameusu");
//     let doccontrato = $(this).data("contrato");
//     let docafiliacion = $(this).data("afiliacion");
//     let docbaja = $(this).data("baja");

//     $("#update_id_document").val(id);
//     $("#update_id_usuario").val(update_id_usuario);
//     $("#usunametitle").text(nameusu); // Cambiado a text() para elementos no inputs


//     // Muestra las rutas en elementos que no sean inputs file
//     $("#contrato-current").html(doccontrato ?
//         `<a href="../../${doccontrato}" target="_blank">Ver contrato actual</a>` :
//         'Ningún contrato cargado');

//     $("#afiliacion-current").html(docafiliacion ?
//         `<a href="${docafiliacion}" target="_blank">Ver afiliación actual</a>` :
//         'Ningún archivo cargado');

//     $("#baja-current").html(docbaja ?
//         `<a href="${docbaja}" target="_blank">Ver baja actual</a>` :
//         'Ningún archivo cargado');

//     // Abre el modal
//     $("#modalActualizarDocs").modal("show");
// });
$(document).on('click', '.actualizarDocs', function() {
    let id = $(this).data("iddoc");
    let update_id_usuario = $(this).data("idus");
    let update_id_region = $(this).data("idre");
    let nameusu = $(this).data("nameusu");
    let doccontrato = $(this).data("contrato");
    let docafiliacion = $(this).data("afiliacion");
    let docbaja = $(this).data("baja");


    // Asignar valores a los campos del modal
    $("#update_id_document").val(id);
    $("#update_id_usuario").val(update_id_usuario);
    $("#update_id_region").val(update_id_region);
    $("#usunametitle").text(nameusu);

    // Muestra las rutas de documentos (ajusta las rutas según tu estructura)
    $("#contrato-current").html(doccontrato ?
        `<a href="../../${doccontrato}" target="_blank" class="btn btn-sm btn-outline-primary">
            <i class="bi bi-file-earmark-text"></i> Ver contrato
        </a>` :
        '<span class="badge bg-secondary">No disponible</span>');

    $("#afiliacion-current").html(docafiliacion ?
        `<a href="../../${docafiliacion}" target="_blank" class="btn btn-sm btn-outline-primary">
            <i class="bi bi-file-earmark-text"></i> Ver afiliación
        </a>` :
        '<span class="badge bg-secondary">No disponible</span>');

    $("#baja-current").html(docbaja ?
        `<a href="../../${docbaja}" target="_blank" class="btn btn-sm btn-outline-primary">
            <i class="bi bi-file-earmark-text"></i> Ver baja
        </a>` :
        '<span class="badge bg-secondary">No disponible</span>');

    // Mostrar modal (versión compatible con Bootstrap 5)
    const modal = new bootstrap.Modal(document.getElementById('modalActualizarDocs'));
    modal.show();
});

$(document).ready(function() {
    $("#formActualizarDocs").submit(function(e) {
        e.preventDefault();

        let formData = new FormData(this);
        $.ajax({
            url: "../../../controllers/actualizarUsuarioDocumentosController.php",
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,
            beforeSend: function() {
                Swal.fire({
                    title: "Actualizando...",
                    text: "Por favor, espera un momento.",
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    },
                });
            },
            success: function(response) {
                let data = JSON.parse(response);
                Swal.fire({
                    icon: data.status === "success" ? "success" : "warning",
                    title: data.status === "success" ? "Éxito" : "Atención",
                    text: data.message,
                }).then(() => {
                    if (data.status === "success") {
                        location.reload();
                    }
                });
            },
            error: function() {
                Swal.fire({
                    icon: "error",
                    title: "Error de conexión",
                    text: "No se pudo conectar con el servidor. Verifica tu conexión a internet.",
                });
            },
        });
    });
});
</script>










<?php require '../../component/FooterAdmin.php' ?>