<?php require '../../component/HeaderAdmin.php' ?>
<?php require '../../component/menuAdmin.php'  ?>



<?php

$id_region = isset($_GET['id_region']) ? intval($_GET['id_region']) : null;
$estadouse = isset($_GET['activo']) ? intval($_GET['activo']) : null;

$edouse = null;
if ($estadouse === 1) {
    $edouse = 'ACTIVO';
} else if ($estadouse === 0) {
    $edouse = 'INACTIVO';
}

?>





<main class="app-main">
    <!--begin::App Content Header-->
    <div class="app-content-header">
        <!--begin::Container-->
        <div class="container-fluid">
            <!--begin::Row-->
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="mb-0">EMPLEADOS </h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-end">
                        <li class="breadcrumb-item"><a href="./dashboard.php">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Dashboard
                        </li>
                    </ol>
                </div>
            </div>
            <!--end::Row-->
        </div>
        <!--end::Container-->
    </div>
    <!--end::App Content Header-->
    <!--begin::App Content-->
    <div class="app-content">
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Datos Generales De Empleados.</h3>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="select-all"></th>
                                    <th>ID</th>
                                    <th>IMG PERFIL</th>
                                    <th>NOMBRE</th>
                                    <th>RFC</th>
                                    <th>ESTADO</th>
                                    <th>ROL</th>
                                    <th>REGIÓN</th>
                                    <th>PUESTO</th>
                                    <th>EMAIL</th>
                                    <th>ACCIONES</th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php

                                // Consulta base
                                $sql = "SELECT te.id_empleado, te.id_empleado_externo, te.nombre_emp, te.user_rfc, 
te.password, te.imgUser, te.estado, te.id_rol, tr.nom_rol, 
te.id_region, tg.nom_region, te.id_puesto, tp.nom_puesto, 
te.email, te.fecha_registro 
FROM tbl_empleados te 
JOIN tbl_rol tr ON tr.id_rol = te.id_rol 
JOIN tbl_region tg ON tg.id_region = te.id_region 
JOIN tbl_puesto tp ON tp.id_puesto = te.id_puesto 
WHERE 1=1";  // Para concatenar condiciones dinámicamente

                                // Array para bind_param
                                $types = '';
                                $params = [];

                                // Validar id_region
                                if (!is_null($id_region)) {
                                    $sql .= " AND te.id_region = ?";
                                    $types .= 'i';
                                    $params[] = &$id_region;
                                }

                                // Validar estado (solo si es ACTIVO o INACTIVO)
                                if (!is_null($edouse)) {
                                    $sql .= " AND te.estado = ?";
                                    $types .= 's';
                                    $params[] = &$edouse;
                                }

                                // Ordenar por fecha de registro
                                $sql .= " ORDER BY te.fecha_registro DESC";

                                // Preparar consulta
                                $stmt = $conexion->prepare($sql);

                                // Si hay parámetros, los vinculamos
                                if (!empty($params)) {
                                    $stmt->bind_param($types, ...$params);
                                }

                                // Ejecutar y obtener resultados
                                $stmt->execute();
                                $result = $stmt->get_result();

                                // Mostrar resultados
                                while ($row = $result->fetch_assoc()) {
                                ?>

                                <tr>
                                    <td>
                                        <!-- Checkbox para seleccionar usuarios -->
                                        <input type="checkbox" class="user-checkbox"
                                            value="<?php echo $row["id_empleado"]; ?>">
                                    </td>
                                    <td><?php echo $row["id_empleado"]; ?></td>
                                    <td class="text-center"><img
                                            src="<?php echo !empty($row['imgUser']) ? '../../../controllers/uploads/imgProfileUser/' . $row['imgUser'] : 'https://icones.pro/wp-content/uploads/2021/02/symbole-masculin-icone-l-utilisateur-gris.png'; ?>"
                                            class="user-image rounded-circle shadow" width="40px" alt="User Image"></td>
                                    <td><?php echo $row["nombre_emp"]; ?></td>
                                    <td><?php echo $row["user_rfc"]; ?></td>
                                    <td>
                                        <?php if ($row["estado"] != 'INACTIVO') { ?>
                                        <span class="badge bg-success float-center"><?php echo $row["estado"]; ?></span>

                                        <?php } else {  ?>
                                        <span class="badge bg-danger float-center"><?php echo $row["estado"]; ?></span>
                                        <?php }  ?>
                                    </td>
                                    <td><?php echo $row["nom_rol"]; ?></td>
                                    <td><?php echo $row["nom_region"]; ?></td>
                                    <td><?php echo $row["nom_puesto"]; ?></td>
                                    <td><?php echo $row["email"]; ?></td>
                                    <td>
                                        
                                    </td>
                                </tr>
                                <?php } ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th><input type="checkbox" id="select-all"></th>
                                    <th>ID</th>
                                    <th>IMG PERFIL</th>
                                    <th>NOMBRE</th>
                                    <th>RFC</th>
                                    <th>ESTADO</th>
                                    <th>ROL</th>
                                    <th>REGIÓN</th>
                                    <th>PUESTO</th>
                                    <th>EMAIL</th>
                                    <th>ACCIONES</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </section>
    </div>
    <!--end::App Content-->
</main>
<!--end::App Main-->
<!--begin::Footer-->




<?php require '../../component/FooterAdmin.php' ?>