<?php require '../../component/HeaderAdmin.php' ?>
<?php require '../../component/menuAdmin.php'  ?>
<main class="app-main">
    <!--begin::App Content Header-->
    <div class="app-content-header">
        <!--begin::Container-->
        <div class="container-fluid">
            <!--begin::Row-->
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="mb-0">Bienvenido: <?php echo  $_SESSION["nombre"]; ?></h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-end">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Dashboard
                        </li>
                    </ol>
                </div>
            </div>
            <!--end::Row-->
        </div>
        <!--end::Container-->
    </div>
    <!--end::App Content Header-->
    <!--begin::App Content-->
    <div class="app-content">
        <!--begin::Container-->
        <div class="container-fluid">
            <!--begin::Row-->
            <div class="row">
                <!--begin::Col-->

                <?php

                $mostrarAdvertencia = empty($_SESSION['imgUser']);
                if ($mostrarAdvertencia) {
                ?>

                <div class="col-lg-12 col-12">
                    <!--begin::Small Box Widget 1-->
                    <div class="small-box text-bg-danger">
                        <div class="inner">
                            <h3>Advertencia</h3>
                            <p>No haz agregado foto de perfil, debes agregar una para completar tu perfil.</p>
                        </div> <svg class="small-box-icon" fill="orange" viewBox="0 0 24 24"
                            xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                            <path
                                d="M12 2L1 21h22L12 2zm0 4.5a1.5 1.5 0 011.5 1.5v6a1.5 1.5 0 01-3 0V8a1.5 1.5 0 011.5-1.5zM12 18a1.5 1.5 0 100-3 1.5 1.5 0 000 3z">
                            </path>
                        </svg>
                    </div>
                    <!--end::Small Box Widget 1-->
                </div>
                <?php } ?>

                <!--end::Col-->
                <div class="col-md-8">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title">Usuarios Registrados por Región</h5>
                            <div class="card-tools"> <button type="button" class="btn btn-tool"
                                    data-lte-toggle="card-collapse"> <i data-lte-icon="expand"
                                        class="bi bi-plus-lg"></i> <i data-lte-icon="collapse"
                                        class="bi bi-dash-lg"></i> </button>
                            </div>
                        </div> <!-- /.card-header -->
                        <div class="card-body">
                            <!--begin::Row-->
                            <div class="row">
                                <?php
                                // Consulta modificada para incluir todas las regiones
                                $sql = "SELECT 
            r.id_region, 
            r.nom_region, 
            COUNT(e.id_empleado) as total 
        FROM tbl_region r
        LEFT JOIN tbl_empleados e ON e.id_region = r.id_region 
        GROUP BY r.id_region, r.nom_region
        ORDER BY r.nom_region ASC"; // Orden alfabético

                                $result = $conexion->query($sql);

                                if ($result->num_rows > 0) {
                                    while ($row = $result->fetch_assoc()) {
                                        $detalle_url = "detalle_region.php?id_region=" . $row["id_region"];
                                        $total = $row["total"] ?: 0; // Asegurar que muestre 0 si es null
                                ?>
                                <div class="col-lg-3 col-6">
                                    <div class="small-box text-bg-<?= $total > 0 ? 'primary' : 'secondary' ?>">
                                        <div class="inner">
                                            <h3><?= $total ?></h3>
                                            <p>USUARIOS EN <?= htmlspecialchars($row["nom_region"]) ?></p>
                                        </div>
                                        <svg class="small-box-icon" fill="currentColor" viewBox="0 0 24 24"
                                            xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                            <path
                                                d="M6.25 6.375a4.125 4.125 0 118.25 0 4.125 4.125 0 01-8.25 0zM3.25 19.125a7.125 7.125 0 0114.25 0v.003l-.001.119a.75.75 0 01-.363.63 13.067 13.067 0 01-6.761 1.873c-2.472 0-4.786-.684-6.76-1.873a.75.75 0 01-.364-.63l-.001-.122zM19.75 7.5a.75.75 0 00-1.5 0v2.25H16a.75.75 0 000 1.5h2.25v2.25a.75.75 0 001.5 0v-2.25H22a.75.75 0 000-1.5h-2.25V7.5z">
                                            </path>
                                        </svg>
                                        <a href="<?= $total > 0 ? $detalle_url : '#' ?>"
                                            class="small-box-footer link-light link-underline-opacity-0 link-underline-opacity-50-hover <?= $total == 0 ? 'disabled' : '' ?>">
                                            Ver información <i class="bi bi-link-45deg"></i>
                                        </a>
                                    </div>
                                </div>
                                <?php
                                    }
                                } else {
                                    echo '<div class="col-12"><div class="alert alert-info">No hay regiones registradas</div></div>';
                                }
                                ?>
                            </div>
                            <!--end::Row-->
                        </div> <!-- ./card-body -->

                    </div> <!-- /.card -->
                </div> <!-- /.col -->

                <!--end::Col-->
               <div class="col-md-4">
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="card-title">ACTIVOS / INACTIVOS</h5>
            <div class="card-tools">
                <button type="button" class="btn btn-tool" data-lte-toggle="card-collapse">
                    <i data-lte-icon="expand" class="bi bi-plus-lg"></i>
                    <i data-lte-icon="collapse" class="bi bi-dash-lg"></i>
                </button>
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <?php
                try {
                    $sql = "SELECT 
                            SUM(estado = 'ACTIVO') as total_activos,
                            SUM(estado = 'INACTIVO') as total_inactivos
                        FROM tbl_empleados";
                    
                    $result = $conexion->query($sql);
                    
                    if (!$result) {
                        throw new Exception("Error en consulta: " . $conexion->error);
                    }
                    
                    $totales = $result->fetch_assoc() ?? ['total_activos' => 0, 'total_inactivos' => 0];
                    
                } catch (Exception $e) {
                    // Registra el error pero muestra valores por defecto
                    error_log($e->getMessage());
                    $totales = ['total_activos' => 0, 'total_inactivos' => 0];
                }
                ?>
                
                <!-- Tarjeta Activos -->
                <div class="col-lg-3 col-6">
                    <div class="small-box text-bg-success">
                        <div class="inner">
                            <h3><?= htmlspecialchars($totales['total_activos']) ?></h3>
                            <p>Usuarios Activos</p>
                        </div>
                        <i class="small-box-icon bi bi-check-circle"></i>
                        <a href="https://mp40mktexperiences.com/dochub/app/view/dashboard/administrador/detalle_region.php?activo=1" class="small-box-footer link-light">
                            Ver detalles <i class="bi bi-link-45deg"></i>
                        </a>
                    </div>
                </div>
                
                <!-- Tarjeta Inactivos -->
                <div class="col-lg-3 col-6">
                    <div class="small-box text-bg-danger">
                        <div class="inner">
                            <h3><?= htmlspecialchars($totales['total_inactivos']) ?></h3>
                            <p>Usuarios Inactivos</p>
                        </div>
                        <i class="small-box-icon bi bi-x-circle"></i>
                        <a href="https://mp40mktexperiences.com/dochub/app/view/dashboard/administrador/detalle_region.php?activo=0" class="small-box-footer link-light">
                            Ver detalles <i class="bi bi-link-45deg"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



            </div>
            <!--end::Row-->
            <!--begin::Row-->
        </div>
        <!--end::Container-->
    </div>
    <!--end::App Content-->
</main>
<!--end::App Main-->
<!--begin::Footer-->



<?php require '../../component/FooterAdmin.php' ?>