<?php require '../../component/HeaderAdmin.php' ?>
<?php require '../../component/menuAdmin.php'  ?>

<style>
/* Opcional: Estilo para el contenedor de resultados */
.result-item {
    padding: 10px;
    border: 1px solid #ddd;
    margin-bottom: 5px;
    cursor: pointer;
    background-color: #f8f9fa;
}

.result-item:hover {
    background-color: #e9ecef;
}

#results {
    display: none;
    /* Ocultar inicialmente */
    max-height: 200px;
    overflow-y: auto;
    border: 1px solid #ccc;
    background-color: #fff;
}
</style>

<main class="app-main">
    <!--begin::App Content Header-->
    <div class="app-content-header">
        <!--begin::Container-->
        <div class="container-fluid">
            <!--begin::Row-->
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="mb-0">AGREGAR CFDI</h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-end">
                        <li class="breadcrumb-item"><a href="./dashboard.php">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Dashboard
                        </li>
                    </ol>
                </div>
            </div>
            <!--end::Row-->
        </div>
        <!--end::Container-->
    </div>
    <!--end::App Content Header-->
    <!--begin::App Content-->
    <div class="app-content">
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Datos Generales y Recibo de Nominas</h3>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        <button class="btn btn-warning mb-3 btn-block" style="font-size: 1.25rem; font-weight: bold;"
                            data-bs-toggle="modal" data-bs-target="#uploadModal"> AGREGAR CFDI </button>





                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>IMG PERFIL</th>
                                    <th>NOMBRE</th>
                                    <th>RFC</th>
                                    <th>ESTADO</th>
                                    <th>ROL</th>
                                    <th>REGIÓN</th>
                                    <th>PUESTO</th>
                                    <th>CFDI</th>
                                    <th>FECHA PAGO</th>
                                    <th>ACCIONES</th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php

                                $consulta = mysqli_query($conexion, "SELECT ta.id_archivo, te.id_empleado, te.imgUser ,te.nombre_emp, te.user_rfc, te.estado, tr.nom_rol, tg.nom_region, tp.nom_puesto, ta.nombre_archivo, ta.ruta_archivo, ta.fechaPago FROM tbl_archivos ta JOIN tbl_empleados te ON te.id_empleado = ta.id_empleado JOIN tbl_rol tr ON tr.id_rol = te.id_rol JOIN tbl_region tg ON tg.id_region = te.id_region JOIN tbl_puesto tp ON tp.id_puesto = te.id_puesto ORDER BY ta.fecha_subida DESC;");
                                while ($row = mysqli_fetch_assoc($consulta)) {
                                ?>

                                <tr>
                                    <td><?php echo $row["id_archivo"]; ?></td>
                                    <td class="text-center"><img
                                            src="<?php echo !empty($row['imgUser']) ? '../../../controllers/uploads/imgProfileUser/' . $row['imgUser'] : 'https://icones.pro/wp-content/uploads/2021/02/symbole-masculin-icone-l-utilisateur-gris.png'; ?>"
                                            class="user-image rounded-circle shadow" width="40px" alt="User Image"></td>
                                    <td><?php echo $row["nombre_emp"]; ?></td>
                                    <td><?php echo $row["user_rfc"]; ?></td>
                                    <td>
                                        <?php if ($row["estado"] != 'INACTIVO') { ?>
                                        <span class="badge bg-success float-center"><?php echo $row["estado"]; ?></span>

                                        <?php } else {  ?>
                                        <span class="badge bg-danger float-center"><?php echo $row["estado"]; ?></span>
                                        <?php }  ?>
                                    </td>
                                    <td><?php echo $row["nom_rol"]; ?></td>
                                    <td><?php echo $row["nom_region"]; ?></td>
                                    <td><?php echo $row["nom_puesto"]; ?></td>
                                    <td><a href="../../../controllers/<?php echo $row["ruta_archivo"]; ?>"
                                            download><?php echo $row["nombre_archivo"]; ?></a><i
                                            class="bi bi-file-earmark-pdf"></i></td>
                                    <td><?php echo $row["fechaPago"]; ?></td>
                                    <td>
                                        <button type="button" class="btn btn-primary btn-sm editar-btn"
                                            data-id_archivo="<?php echo $row['id_archivo']; ?>"
                                            data-nameuser="<?php echo $row['nombre_emp']; ?>"
                                            data-usuarioID="<?php echo $row['id_empleado']; ?>"
                                            data-pagoDate="<?php echo $row['fechaPago']; ?>">
                                            <i class="bi bi-pencil-square"></i> Editar
                                        </button>

                                    </td>
                                </tr>
                                <?php } ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>ID</th>
                                    <th>IMG PERFIL</th>
                                    <th>NOMBRE</th>
                                    <th>RFC</th>
                                    <th>ESTADO</th>
                                    <th>ROL</th>
                                    <th>REGIÓN</th>
                                    <th>PUESTO</th>
                                    <th>CFDI</th>
                                    <th>FECHA PAGO</th>
                                    <th>ACCIONES</th>

                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </section>
    </div>
    <!--end::App Content-->
</main>
<!--end::App Main-->
<!--begin::Footer-->


<!-- Modal -->
<div class="modal fade" id="uploadModal" tabindex="-1" aria-labelledby="uploadModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="uploadModalLabel">
                    <i class="bi bi-file-earmark-pdf"></i> Subir Documentos PDF
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <div class="modal-body">
                <form id="uploadForm" enctype="multipart/form-data">
                    <!-- Selección de Usuario -->
                    <div class="mb-3">
                        <label for="nombre">Seleccione Usuario</label>
                        <input type="text" id="searchInput" class="form-control mb-3" placeholder="Buscar..." autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="false">
                        <input type="hidden" id="searchInputID" name="searchInputID">
                        <div id="results"></div>
                    </div>

                    <!-- Input de fecha -->
                    <div class="mb-3">
                        <label for="fechaPago" class="form-label">Seleccionar fecha a la que pertenece el pago</label>
                        <input type="date" class="form-control" id="fechaPago" name="fechaPago" required>
                        <small class="text-muted">Seleccione la fecha correspondiente al pago.</small>
                    </div>

                    <!-- Input de archivos -->
                    <div class="mb-3">
                        <label for="zipFile" class="form-label">Seleccionar Documentos en .ZIP</label>
                        <input type="file" class="form-control" id="zipFile" name="zipFile"
                            accept=".zip, application/zip, application/x-zip-compressed" required
                            data-max-size="10485760">
                        <small class="text-muted">Solo archivos .zip (Máximo 10MB)</small>
                    </div>

                    <!-- Vista previa de archivos -->
                    <div id="filePreview" class="mt-3"></div>

                    <!-- Botón de subida -->
                    <button type="submit" class="btn btn-success w-100 mt-3">
                        <i class="bi bi-cloud-upload"></i> Subir Documentos
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>


<!-- Modal para editar -->
<!-- Modal para editar archivo -->
<div class="modal fade" id="editFileModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title"><i class="bi bi-pencil-square"></i> Editar Documento</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <div class="modal-body">
                <form id="editFileForm" enctype="multipart/form-data">
                    <input type="hidden" id="idArchivo" name="idArchivo">
                    <input type="hidden" id="usuarioID" name="usuarioID">

                    <div class="mb-3">
                        <label for="nombreUsuario" class="form-label">Nombre del usuario</label>
                        <input type="text" class="form-control" id="nombreUsuario" readonly>
                    </div>

                    <div class="mb-3">
                        <label for="fechaPago" class="form-label">Fecha de pago</label>
                        <input type="date" class="form-control" id="fechaPago" name="fechaPago">
                    </div>

                    <div class="mb-3">
                        <label for="nuevoArchivo" class="form-label">Seleccionar nuevo archivo</label>
                        <input type="file" class="form-control" id="nuevoArchivo" name="nuevoArchivo"
                            accept=".zip, application/zip, application/x-zip-compressed" data-max-size="10485760">
                        <small class="text-muted">Solo archivos .zip (Máximo 10MB)</small>
                    </div>

                    <button type="submit" class="btn btn-warning w-100 mt-3"><i class="bi bi-save"></i> Guardar
                        Cambios</button>
                </form>
            </div>
        </div>
    </div>
</div>




<script>
document
    .getElementById("zipFile")
    .addEventListener("change", function(event) {
        let filePreview = document.getElementById("filePreview");
        filePreview.innerHTML = ""; // Limpiar vista previa
        let files = event.target.files;

        if (files.length > 0) {
            let list = document.createElement("ul");
            list.className = "list-group mt-2";

            for (let file of files) {
                let listItem = document.createElement("li");
                listItem.className =
                    "list-group-item d-flex justify-content-between align-items-center";
                listItem.innerHTML = `<i class="bi bi-file-earmark-pdf text-danger"></i> ${
                file.name
              } <span class="badge bg-secondary">${(file.size / 1024).toFixed(
                2
              )} KB</span>`;
                list.appendChild(listItem);
            }

            filePreview.appendChild(list);
        }
    });

// Evento de clic para mostrar resultados de los usuarios a buscar 'SCRIPT DE BUSQUEDA EN TIEMPO REAL DE USUARIOS'
$(document).ready(function() {
    // Evento de clic para mostrar resultados
    $('#searchInput').on('focus', function() {
        $('#results').fadeIn(); // Mostrar el contenedorsultados

        // Realizar la búsqueda cuando el input recibe foco (mostrar todos los resultados si el input está vacío)
        const query = $(this).val(); // Tomar el valor actual del input

        // Si el campo está vacío, mostrar todos los resultados
        if (query === '') {
            fetchResults('');
        }
    });

    // Evento de búsqueda en tiempo real
    $('#searchInput').on('keyup', function() {
        const query = $(this).val();

        // Llamada AJAX al servidor
        fetchResults(query);
    });

    // Función para hacer la llamada AJAX y actualizar los resultados
    function fetchResults(query) {
        $.ajax({
            url: '../../../controllers/searchUsuariosController.php', // Archivo PHP que maneja la búsqueda
            method: 'GET',
            data: {
                q: query
            }, // Enviar término de búsqueda
            dataType: 'json',
            success: function(data) {
                //console.log(data);
                let resultsHTML = '';

                if (data.length > 0) {
                    data.forEach(item => {
                        resultsHTML += `
                            <div class="result-item" data-id="${item.id_empleado}" data-name="${item.nombre_emp}" >
                                <strong>${item.nombre_emp}</strong><br>
                                <small>${item.user_rfc}</small>
                            </div>
                        `;
                    });
                } else {
                    resultsHTML =
                        '<p class="text-muted px-2">No se encontraron resultados</p>';
                }

                $('#results').html(resultsHTML);
            },
            error: function(xhr, status, error) {
                console.error("Error:", error);
                $('#results').html(
                    `<p class="text-danger px-2">Error al buscar datos: ${error}</p>`
                );
            }
        });
    }

    // Ocultar resultados al hacer clic en un resultado
    $(document).on("click", ".result-item", function() {
        const id = $(this).data("id");
        const name = $(this).data("name");
        const apellido = $(this).data("apellido");
        const nombrecompleto = name;
        $("#searchInput").val(nombrecompleto); // Poner el id en el input
        $("#searchInputID").val(id); // Poner el id en el input
        $("#results").fadeOut(); // Ocultar los resultados
    });

    // Ocultar resultados al hacer clic fuera del input
    $(document).on('click', function(e) {
        if (!$(e.target).closest('#searchInput, #results').length) {
            $('#results').fadeOut();
        }
    });
});

$(document).ready(function() {
    $("#uploadForm").submit(async function(e) {
        e.preventDefault();

        // Obtener datos del formulario
        let formData = new FormData(this);
        let zipFile = $("#zipFile")[0].files[0]; // Cambiado a input para ZIP
        let usuarioID = $("#searchInputID").val().trim();
        let fechaPago = $("#fechaPago").val().trim();

        // Validación mejorada
        if (!usuarioID) {
            await Swal.fire({
                icon: 'error',
                title: 'Usuario requerido',
                text: 'Debes seleccionar un usuario válido',
                confirmButtonColor: '#dc3545'
            });
            return;
        }

        if (!fechaPago) {
            await Swal.fire({
                icon: 'error',
                title: 'Fecha requerida',
                text: 'Selecciona una fecha de pago válida',
                confirmButtonColor: '#dc3545'
            });
            return;
        }

        if (!zipFile) {
            await Swal.fire({
                icon: 'error',
                title: 'Archivo requerido',
                text: 'Debes seleccionar un archivo ZIP',
                confirmButtonColor: '#dc3545'
            });
            return;
        }

        // Validar tipo de archivo (ZIP)
        const zipExtensions = ['application/zip', 'application/x-zip-compressed'];
        if (!zipExtensions.includes(zipFile.type) && !zipFile.name.toLowerCase().endsWith('.zip')) {
            await Swal.fire({
                icon: 'error',
                title: 'Formato incorrecto',
                html: `El archivo <strong>${zipFile.name}</strong> no es un ZIP válido`,
                confirmButtonColor: '#dc3545'
            });
            return;
        }

        // Validar tamaño (10MB máximo)
        if (zipFile.size > 10 * 1024 * 1024) {
            await Swal.fire({
                icon: 'error',
                title: 'Archivo muy grande',
                html: `Tamaño: <strong>${(zipFile.size/(1024*1024)).toFixed(2)}MB</strong><br>Límite: 10MB`,
                confirmButtonColor: '#dc3545'
            });
            return;
        }

        // Mostrar progreso de carga
        Swal.fire({
            title: 'Subiendo archivo ZIP...',
            html: `
                <div class="progress mt-3">
                    <div id="zipProgress" class="progress-bar progress-bar-striped progress-bar-animated" 
                         role="progressbar" style="width: 0%"></div>
                </div>
                <p class="mt-2">Por favor espera...</p>
            `,
            allowOutsideClick: false,
            showConfirmButton: false
        });

        // Configurar AJAX
        try {
            const response = await $.ajax({
                url: "../../../controllers/cargaZipController.php", // Cambiado a controlador ZIP
                type: "POST",
                data: formData,
                contentType: false,
                processData: false,
                cache: false,
                xhr: function() {
                    const xhr = new XMLHttpRequest();
                    xhr.upload.addEventListener('progress', function(e) {
                        if (e.lengthComputable) {
                            const percent = Math.round((e.loaded / e.total) *
                                100);
                            $('#zipProgress').css('width', percent + '%');
                        }
                    });
                    return xhr;
                }
            });

            // Procesar respuesta
            const result = typeof response === 'string' ? JSON.parse(response) : response;

            if (result.status === "success") {
                await Swal.fire({
                    title: "¡Éxito!",
                    html: `El archivo ZIP <strong>${zipFile.name}</strong> se subió correctamente`,
                    icon: "success",
                    confirmButtonColor: '#28a745',
                    confirmButtonText: "Aceptar"
                });

                // Resetear formulario
                $("#uploadModal").modal("hide");
                $("#uploadForm")[0].reset();
                location.reload();
            } else {
                throw new Error(result.message || 'Error en el servidor');
            }
        } catch (error) {
            await Swal.fire({
                icon: 'error',
                title: 'Error en la subida',
                text: error.message || 'No se pudo conectar con el servidor',
                confirmButtonColor: '#dc3545'
            });
            console.error('Error en AJAX:', error);
        }
    });
});



//script para mostrar los datos en el modal de editar
document.addEventListener("DOMContentLoaded", function() {
    // Detectamos clics en cualquier parte del documento
    document.addEventListener("click", function(event) {
        // Verificamos si el clic fue en un botón de edición
        if (event.target.closest(".editar-btn")) {
            let boton = event.target.closest(".editar-btn");

            // Obtener referencias a los campos del modal
            let modal = document.getElementById("editFileModal");

            // Llenar los campos con los atributos del botón
            modal.querySelector("#idArchivo").value = boton.getAttribute("data-id_archivo");
            modal.querySelector("#usuarioID").value = boton.getAttribute("data-usuarioID");
            modal.querySelector("#nombreUsuario").value = boton.getAttribute("data-nameuser");
            modal.querySelector("#fechaPago").value = boton.getAttribute("data-pagoDate");

            // Mostrar el modal
            let modalInstance = new bootstrap.Modal(modal);
            modalInstance.show();
        }
    });
});




$(document).ready(function() {
    $('#editFileForm').submit(async function(e) {
        e.preventDefault();

        // Obtener datos del formulario
        const formData = new FormData(this);
        const nuevoArchivo = $('#nuevoArchivo')[0].files[0];
        const fechaPago = $('#fechaPago').val();
        const idArchivo = $('#idArchivo').val();
        const usuarioID = $('#usuarioID').val();



        // Validar archivo ZIP si se proporciona
        if (nuevoArchivo) {
            // Validar tipo
            const zipMimes = ['application/zip', 'application/x-zip-compressed'];
            if (!zipMimes.includes(nuevoArchivo.type) && !nuevoArchivo.name.toLowerCase().endsWith(
                    '.zip')) {
                await Swal.fire({
                    icon: 'error',
                    title: 'Formato incorrecto',
                    html: `El archivo <strong>${nuevoArchivo.name}</strong> no es un ZIP válido`,
                    confirmButtonColor: '#dc3545'
                });
                return;
            }

            // Validar tamaño (10MB)
            if (nuevoArchivo.size > 10 * 1024 * 1024) {
                await Swal.fire({
                    icon: 'error',
                    title: 'Archivo muy grande',
                    html: `Tamaño: <strong>${(nuevoArchivo.size/(1024*1024)).toFixed(2)}MB</strong><br>Límite: 10MB`,
                    confirmButtonColor: '#dc3545'
                });
                return;
            }
        }

        // Mostrar carga
        const swalInstance = Swal.fire({
            title: 'Actualizando documento...',
            html: `
                <div class="progress mt-3">
                    <div id="updateProgress" class="progress-bar progress-bar-striped progress-bar-animated" 
                         role="progressbar" style="width: 0%"></div>
                </div>
                <p class="mt-2">Por favor espera...</p>
            `,
            allowOutsideClick: false,
            showConfirmButton: false
        });

        try {
            // Enviar datos al servidor
            const response = await $.ajax({
                url: '../../../controllers/actualizarDocumentoZipController.php',
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                cache: false,
                xhr: function() {
                    const xhr = new XMLHttpRequest();
                    xhr.upload.addEventListener('progress', function(e) {
                        if (e.lengthComputable &&
                            nuevoArchivo
                        ) { // Solo mostrar progreso si hay archivo
                            const percent = Math.round((e.loaded / e.total) *
                                100);
                            $('#updateProgress').css('width', percent + '%');
                        }
                    });
                    return xhr;
                }
            });

            // Procesar respuesta
            const result = typeof response === 'string' ? JSON.parse(response) : response;

            if (result.status === 'success') {
                await Swal.fire({
                    icon: 'success',
                    title: '¡Actualizado!',
                    text: result.message || 'Cambios guardados correctamente',
                    confirmButtonColor: '#28a745'
                });

                // Cerrar modal y recargar datos
                $('#editFileModal').modal('hide');
                location.reload();
            } else {
                throw new Error(result.message || 'Error al actualizar');
            }
        } catch (error) {
            await Swal.fire({
                icon: 'error',
                title: 'Error',
                text: error.message || 'No se pudo completar la actualización',
                confirmButtonColor: '#dc3545'
            });
            console.error('Error al actualizar:', error);
        } finally {
            swalInstance.close();
        }
    });
});
</script>









<?php require '../../component/FooterAdmin.php' ?>