<?php
session_start();
require_once(__DIR__ . '/../../../config/config.php');

if (!isset($_SESSION["rfc"])) {
    header("Location: " . $URL . "/public/index.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<!--begin::Head-->

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title> <?php echo APP_NAME; ?> </title>
    <!--begin::Primary Meta Tags-->
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="title" content="<?php echo APP_NAME; ?>">
    <link rel="icon" href="<?php echo $URL ?>/public/IMG/DOC HUB.svg" type="image/x-icon">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fontsource/source-sans-3@5.0.12/index.css"
        integrity="sha256-tXJfXfp6Ewt1ilPzLDtQnJV4hclT9XuaZUKyUvmyr+Q=" crossorigin="anonymous">
    <!--end::Fonts-->
    <!--begin::Third Party Plugin(OverlayScrollbars)-->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/overlayscrollbars@2.3.0/styles/overlayscrollbars.min.css"
        integrity="sha256-dSokZseQNT08wYEWiz5iLI8QPlKxG+TswNRD8k35cpg=" crossorigin="anonymous">
    <!--end::Third Party Plugin(OverlayScrollbars)-->
    <!--begin::Third Party Plugin(Bootstrap Icons)-->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.min.css"
        integrity="sha256-Qsx5lrStHZyR9REqhUF8iQt73X06c8LGIUPzpOhwRrI=" crossorigin="anonymous">
    <!--end::Third Party Plugin(Bootstrap Icons)-->
    <!--begin::Required Plugin(AdminLTE)-->
    <link rel="stylesheet" href="<?php echo $URL ?>/public/template/dist/css/adminlte.css">
    <!--end::Required Plugin(AdminLTE)-->
    <!-- apexcharts -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/apexcharts@3.37.1/dist/apexcharts.css"
        integrity="sha256-4MX+61mt9NVvvuPjUWdUdyfZfxSB1/Rf9WtqRHgG5S0=" crossorigin="anonymous"><!-- jsvectormap -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jsvectormap@1.5.3/dist/css/jsvectormap.min.css"
        integrity="sha256-+uGLJmmTKOqBr+2E6KDYs/NRsHxSkONXFHUL0fy2O/4=" crossorigin="anonymous">

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- DataTables CSS -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.css">
    <!-- Responsive Extension CSS -->
    <link rel="stylesheet" type="text/css"
        href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.dataTables.min.css">
    <!-- Buttons Extension CSS -->
    <link rel="stylesheet" type="text/css"
        href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
     <script src="https://cdn.jsdelivr.net/npm/browser-image-compression@2.0.2/dist/browser-image-compression.js"></script>
    <script src="https://unpkg.com/heic2any/dist/heic2any.min.js"></script>
</head>
<!--end::Head-->
<!--begin::Body-->


<body class="layout-fixed sidebar-expand-lg bg-body-tertiary">
    <!--begin::App Wrapper-->
    <div class="app-wrapper">
        <!--begin::Header-->

        <nav class="app-header navbar navbar-expand bg-body">
            <!--begin::Container-->
            <div class="container-fluid">
                <!--begin::Start Navbar Links-->
                <ul class="navbar-nav">
                    <li class="nav-item"> <a class="nav-link" data-lte-toggle="sidebar" href="#" role="button"> <i
                                class="bi bi-list"></i> </a> </li>
                    <li class="nav-item d-none d-md-block">

                        <?php
                        // Mapeo de roles a rutas
                        $rutasPorRol = [
                            1 => $URL . '/app/view/dashboard/administrador/dashboard.php', // Administrador
                            2 => $URL . '/app/view/dashboard/empleado/dashboard.php',    // Mando medio
                            3 => $URL . '/app/view/dashboard/poa/dashboard.php',
                            4 => $URL . '/app/view/dashboard/coordinador-general/dashboard.php',        // Recursos Humanos
                            // Agrega más roles aquí si es necesario
                        ];

                        // Obtener la ruta según el rol del usuario

                        $rutaInicio = $rutasPorRol[$_SESSION['rol']] ?? '#'; // Usar '#' como valor predeterminado si el rol no existe

                        // Mostrar el enlace de inicio
                        echo "<a href='$rutaInicio' class='nav-link'>Inicio </a>";
                        ?>




                    </li>

                </ul>
                <!--end::Start Navbar Links-->
                <!--begin::End Navbar Links-->
                <ul class="navbar-nav ms-auto">
                    <!--begin::Navbar Search-->
                    <!-- <li class="nav-item"> <a class="nav-link" data-widget="navbar-search" href="#" role="button"> <i
                                class="bi bi-search"></i> </a> </li> -->
                    <!--end::Navbar Search-->
                    <!--begin::Messages Dropdown Menu-->

                    <!--end::Messages Dropdown Menu-->
                    <!--begin::Notifications Dropdown Menu-->
                    <!-- <li class="nav-item dropdown"> <a class="nav-link" data-bs-toggle="dropdown" href="#"> <i
                                class="bi bi-bell-fill"></i> <span class="navbar-badge badge text-bg-warning">15</span>
                        </a>
                        <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end"> <span
                                class="dropdown-item dropdown-header">15 Notifications</span>
                            <div class="dropdown-divider"></div> <a href="#" class="dropdown-item"> <i
                                    class="bi bi-envelope me-2"></i> 4 new messages
                                <span class="float-end text-secondary fs-7">3 mins</span> </a>
                            <div class="dropdown-divider"></div> <a href="#" class="dropdown-item"> <i
                                    class="bi bi-people-fill me-2"></i> 8 friend requests
                                <span class="float-end text-secondary fs-7">12 hours</span> </a>
                            <div class="dropdown-divider"></div> <a href="#" class="dropdown-item"> <i
                                    class="bi bi-file-earmark-fill me-2"></i> 3 new reports
                                <span class="float-end text-secondary fs-7">2 days</span> </a>
                            <div class="dropdown-divider"></div> <a href="#" class="dropdown-item dropdown-footer">
                                See All Notifications
                            </a>
                        </div>
                    </li> -->
                    <!--end::Notifications Dropdown Menu-->
                    <!--begin::Fullscreen Toggle-->
                    <li class="nav-item"> <a class="nav-link" href="#" data-lte-toggle="fullscreen"> <i
                                data-lte-icon="maximize" class="bi bi-arrows-fullscreen"></i> <i
                                data-lte-icon="minimize" class="bi bi-fullscreen-exit" style="display: none;"></i> </a>
                    </li>
                    <!--end::Fullscreen Toggle-->
                    <!--MENU PARA VER USUARIOS, OPTION CERRAR SESION-->
                    <?php
                    $userID = $_SESSION["id"];
                    $consulta = mysqli_query($conexion, "SELECT te.id_empleado, te.nombre_emp, te.user_rfc ,te.imgUser, te.id_rol, tr.nom_rol ,te.id_region, tre.nom_region , te.id_puesto, tp.nom_puesto FROM tbl_empleados te JOIN tbl_rol tr ON tr.id_rol = te.id_rol JOIN tbl_region tre ON tre.id_region = te.id_region JOIN tbl_puesto tp ON tp.id_puesto = te.id_puesto WHERE te.id_empleado = $userID");
                    while ($row = mysqli_fetch_assoc($consulta)) {

                    ?>
                    <li class="nav-item dropdown user-menu shadow-sm rounded"> <a href="#"
                            class="nav-link dropdown-toggle" data-bs-toggle="dropdown"> <img
                                src="<?php echo !empty($row['imgUser']) ? '../../../controllers/uploads/imgProfileUser/' . $row['imgUser'] : 'https://icones.pro/wp-content/uploads/2021/02/symbole-masculin-icone-l-utilisateur-gris.png'; ?>"
                                class="user-image rounded-circle shadow" alt="User Image"> <span
                                class="d-none d-md-inline"><?php echo $row["nom_rol"]; ?></span> </a>
                        <ul class="dropdown-menu dropdown-menu-lg dropdown-menu-end">
                            <!--begin::User Image-->
                            <li class="user-header text-bg-primary"> <img
                                    src="<?php echo !empty($row['imgUser']) ? '../../../controllers/uploads/imgProfileUser/' . $row['imgUser'] : 'https://icones.pro/wp-content/uploads/2021/02/symbole-masculin-icone-l-utilisateur-gris.png'; ?>"
                                    class="rounded-circle shadow" alt="User Image">
                                <p>
                                    <?php echo  $_SESSION["nombre"]; ?>
                                    <!-- <small class="hidden">Member since Nov. 2023</small> -->
                                </p>
                            </li>
                            <!--end::User Image-->
                            <!--begin::Menu Body-->
                            <li class="user-body">
                                <!--begin::Row-->
                                <div class="row">
                                    <div class="col-6 text-center"> <span class="fw-bolder">REGIÓN:</span>
                                    </div>
                                    <div class="col-6 text-center"> <span class="fw-bolder">PUESTO:</span>
                                    </div>
                                    <div class="col-6 text-center"> <a href="#"><?php echo $row["nom_region"]; ?></a>
                                    </div>
                                    <div class="col-6 text-center"> <a href="#"><?php echo $row["nom_puesto"]; ?></a>
                                    </div>
                                </div>
                                <!--end::Row-->
                            </li>
                            <!--end::Menu Body-->
                            <!--begin::Menu Footer-->

                            <li class="user-footer">
                                <button class="btn btn-default btn-flat btn-updateImg"
                                    data-usid="<?php echo $userID ?>">Perfil</button>
                                <a href="<?php echo $URL ?>/app/controllers/logout.php"
                                    class="btn btn-danger btn-sm shadow-sm float-end"><i
                                        class="bi bi-box-arrow-right"></i> Cerrar Sesión</a>
                            </li>
                            <!--end::Menu Footer-->

                        </ul>
                    </li>
                    <!--end::User Menu Dropdown-->

                    <?php } ?>
                </ul>
                <!--end::End Navbar Links-->
            </div>
            <!--end::Container-->
        </nav>
        <!--end::Header-->
        <!--begin::Sidebar-->






        <div class="modal fade" id="modalFoto" tabindex="-1" aria-labelledby="modalFotoLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalFotoLabel">Actualizar Foto de Perfil</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                    </div>
                    <div class="modal-body text-center">
                        <div class="mb-3">
                            <img id="previewImg" src="img/default.png" class="img-thumbnail rounded-circle" width="150"
                                height="150">
                        </div>
                        <input type="file" id="fotoPerfil" class="form-control" accept="image/*">
                        <input type="hidden" name="iduseFoto" id="iduseFoto">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="button" class="btn btn-primary" id="subirFoto">Subir</button>
                    </div>
                </div>
            </div>
        </div>






        <script>
        /*
        document.addEventListener("DOMContentLoaded", function() {
            // Detectamos clics en cualquier parte del documento
            document.addEventListener("click", function(event) {
                // Verificamos si el clic fue en un botón de edición
                if (event.target.closest(".btn-updateImg")) {
                    let boton = event.target.closest(".btn-updateImg");

                    // Obtener referencias a los campos del modal
                    let modal = document.getElementById("modalFoto");

                    // Llenar los campos con los atributos del botón
                    modal.querySelector("#iduseFoto").value = boton.getAttribute("data-usid");
                    // Mostrar el modal
                    let modalInstance = new bootstrap.Modal(modal);
                    modalInstance.show();
                }
            });
        });






        $('#fotoPerfil').on('change', function() {
            const file = this.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    $('#previewImg').attr('src', e.target.result);
                };
                reader.readAsDataURL(file);
            }
        });

        // Enviar la imagen al servidor
        $('#subirFoto').on('click', function() {
            const formData = new FormData();
            const file = $('#fotoPerfil')[0].files[0];
            const idUsuario = $('#iduseFoto').val();

            if (!file) {
                Swal.fire({
                    title: "Error",
                    text: 'Por favor, selecciona una imagen',
                    icon: "error",
                    confirmButtonText: "Aceptar"
                })
                //alert('Por favor, selecciona una imagen.');
                return;
            }

            formData.append('fotoPerfil', file);
            formData.append('iduseFoto', idUsuario);


            $.ajax({
                url: '../../../controllers/cargarImgUserController.php', // Ruta al controlador PHP
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    try {
                        const res = JSON.parse(response);
                        if (res.status === 'success') {
                            Swal.fire({
                                title: "¡Éxito!",
                                text: res.message,
                                icon: "success",
                                confirmButtonText: "Aceptar"
                            }).then(() => {
                                $('#modalFoto').modal('hide'); // Cerrar el modal
                                location.reload();
                            });
                        } else {
                            Swal.fire("Error", res.message, "error");
                        }

                    } catch (error) {
                        Swal.fire("Error", "Error inesperado en la respuesta del servidor.",
                            "error");
                    }
                },
                error: function() {
                    Swal.fire("Error", "No se pudo conectar con el servidor.", "error");
                }
            });
        });
        */
   /*
   document.addEventListener("DOMContentLoaded", function() {
            // 1. Clic en botón de edición (código original)
            document.addEventListener("click", function(event) {
                if (event.target.closest(".btn-updateImg")) {
                    const boton = event.target.closest(".btn-updateImg");
                    const modal = document.getElementById("modalFoto");
                    modal.querySelector("#iduseFoto").value = boton.getAttribute("data-usid");
                    const modalInstance = new bootstrap.Modal(modal);
                    modalInstance.show();
                }
            });

            // 2. Conversión HEIC + Compresión + Previsualización
            $('#fotoPerfil').on('change', function() {
                const file = this.files[0];
                if (!file) return;

                // 1. Detectar HEIC O HEIF
                const isHeicOrHeif = file.name.match(/\.heic|\.heif$/i); // <- Detecta ambos

                if (isHeicOrHeif) {
                    Swal.fire({
                        title: "Convirtiendo imagen...",
                        text: "Convirtiendo a JPG...",
                        icon: "info",
                        showConfirmButton: false,
                        allowOutsideClick: false
                    });

                    // 2. Especificar el tipo MIME para HEIF (opcional pero recomendado)
                    const options = {
                        blob: file,
                        toType: 'image/jpeg',
                        quality: 0.8,
                        // Asegura que HEIF se procese como HEIC
                        mimeType: file.type.includes('heif') ? 'image/heic' : undefined
                    };

                    heic2any(options)
                        .then(blobJPG => {
                            const fileJPG = new File([blobJPG], file.name.replace(/\.[^/.]+$/,
                                '.jpg'), {
                                type: 'image/jpeg'
                            });
                            const dataTransfer = new DataTransfer();
                            dataTransfer.items.add(fileJPG);
                            this.files = dataTransfer.files;

                            const reader = new FileReader();
                            reader.onload = function(e) {
                                $('#previewImg').attr('src', e.target.result);
                                Swal.close();
                            };
                            reader.readAsDataURL(fileJPG);
                        })
                        .catch(error => {
                            Swal.fire("Error", "No se pudo convertir la imagen.", "error");
                            console.error("Error en heic2any:", error);
                        });
                } else {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        $('#previewImg').attr('src', e.target.result);
                    };
                    reader.readAsDataURL(file);
                }
            });

            // 3. Enviar imagen al servidor (código original mejorado)
            $('#subirFoto').on('click', function() {
                const file = $('#fotoPerfil')[0].files[0];
                const idUsuario = $('#iduseFoto').val();

                if (!file) {
                    Swal.fire("Error", "Selecciona una imagen.", "error");
                    return;
                }

                // Validar tamaño (ejemplo: máximo 5MB)
                if (file.size > 10 * 1024 * 1024) {
                    Swal.fire("Error", "La imagen no debe superar 5MB.", "error");
                    return;
                }

                const formData = new FormData();
                formData.append('fotoPerfil', file);
                formData.append('iduseFoto', idUsuario);

                $.ajax({
                    url: '../../../controllers/cargarImgUserController.php',
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        try {
                            const res = JSON.parse(response);
                            if (res.status === 'success') {
                                Swal.fire({
                                    title: "¡Éxito!",
                                    text: res.message,
                                    icon: "success",
                                    confirmButtonText: "Aceptar"
                                }).then(() => {
                                    $('#modalFoto').modal('hide');
                                    location.reload();
                                });
                            } else {
                                Swal.fire("Error", res.message, "error");
                            }
                        } catch (error) {
                            Swal.fire("Error", "Error en la respuesta del servidor.",
                                "error");
                        }
                    },
                    error: function(xhr) {
                        Swal.fire("Error",
                            `Error al conectar: ${xhr.statusText || "Servidor no disponible"}`,
                            "error");
                    }
                });
            });
        });*/
        
        
        
        document.addEventListener("DOMContentLoaded", function() {
    // Función para comprimir la imagen
    async function compressImage(file) {
        const options = {
            maxSizeMB: 0.2, // Tamaño máximo deseado 
            maxWidthOrHeight: 500, // Máximo ancho o alto (ajusta según sea necesario)
            useWebWorker: true,
        };
        try {
            return await imageCompression(file, options);
        } catch (error) {
            console.error("Error al comprimir la imagen:", error);
            Swal.fire("Error", "No se pudo comprimir la imagen.", "error");
            return null;
        }
    }

    // 1. Clic en botón de edición
    document.addEventListener("click", function(event) {
        if (event.target.closest(".btn-updateImg")) {
            const boton = event.target.closest(".btn-updateImg");
            const modal = document.getElementById("modalFoto");
            modal.querySelector("#iduseFoto").value = boton.getAttribute("data-usid");
            const modalInstance = new bootstrap.Modal(modal);
            modalInstance.show();
        }
    });

    // 2. Conversión HEIC + Compresión + Previsualización
    $('#fotoPerfil').on('change', async function() {
        const file = this.files[0];
        if (!file) return;

        // Validar tipo de archivo
        const allowedTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/heic', 'image/heif'];
        if (!allowedTypes.includes(file.type)) {
            Swal.fire("Error", "Tipo de archivo no válido. Solo se permiten JPEG, PNG, GIF, HEIC y HEIF.", "error");
            this.value = ''; // Limpiar el input
            $('#previewImg').attr('src', '');
            return;
        }

        // Validar tamaño del archivo (ejemplo: máximo 10MB)
        if (file.size > 10 * 1024 * 1024) {
            Swal.fire("Error", "La imagen no debe superar 10MB.", "error");
            this.value = ''; // Limpiar el input
            $('#previewImg').attr('src', '');
            return;
        }

        let compressedFile = file;

        // Comprimir la imagen
        Swal.fire({
            title: "Procesando imagen...",
            text: "Comprimiendo y convirtiendo...",
            icon: "info",
            showConfirmButton: false,
            allowOutsideClick: false
        });

        if (file.type === 'image/heic' || file.type === 'image/heif'){
            const options = {
                blob: file,
                toType: 'image/jpeg',
                quality: 0.9,
                mimeType: file.type.includes('heif') ? 'image/heic' : undefined
            };

            try {
                compressedFile = await heic2any(options);
                compressedFile = new File([compressedFile], file.name.replace(/\.[^/.]+$/, '.jpg'), { type: 'image/jpeg' });
            } catch (error) {
                Swal.fire("Error", "No se pudo convertir la imagen HEIC/HEIF.", "error");
                console.error("Error en heic2any:", error);
                Swal.close();
                return;
            }
        }

        compressedFile = await compressImage(compressedFile);
        if (!compressedFile) return;

        const reader = new FileReader();
        reader.onload = function(e) {
            $('#previewImg').attr('src', e.target.result);
            Swal.close();
        };
        reader.readAsDataURL(compressedFile);

        // Actualizar el input con el archivo comprimido
        const dataTransfer = new DataTransfer();
        dataTransfer.items.add(compressedFile);
        this.files = dataTransfer.files;
    });

    // 3. Enviar imagen al servidor
    $('#subirFoto').on('click', function() {
        const file = $('#fotoPerfil')[0].files[0];
        const idUsuario = $('#iduseFoto').val();

        if (!file) {
            Swal.fire("Error", "Selecciona una imagen.", "error");
            return;
        }

        const formData = new FormData();
        formData.append('fotoPerfil', file);
        formData.append('iduseFoto', idUsuario);

        $.ajax({
        url: '../../../controllers/cargarImgUserController.php',
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        dataType: 'json', 
        success: function(response) { 
            if (response.status === 'success') {
                Swal.fire({
                    title: "¡Éxito!",
                    text: response.message,
                    icon: "success",
                    confirmButtonText: "Aceptar"
                }).then(() => {
                    $('#modalFoto').modal('hide');
                    location.reload();
                });
            } else {
                Swal.fire("Error", response.message, "error");
            }
        },
        error: function(xhr) {
            Swal.fire("Error", `Error al conectar: ${xhr.statusText || "Servidor no disponible"}`, "error");
        }
    });
    });
});
        
        

        </script>