<?php

// // Iniciar sesión
// session_start();

// // Incluir archivo de configuración para la conexión a MySQL
// require '../../config/config.php';

// // 🛠️ Configurar conexión persistente
// $conexion->options(MYSQLI_OPT_CONNECT_TIMEOUT, 10); // Tiempo máximo de conexión

// // Función para validar RFC (México)
// function validarRFC($rfc)
// {
//     $pattern = "/^([A-ZÑ&]{3,4})\\d{6}([A-Z0-9]{3})?$/";
//     return preg_match($pattern, strtoupper($rfc));
// }

// // Función para validar email
// function validarEmail($email)
// {
//     return filter_var($email, FILTER_VALIDATE_EMAIL);
// }

// // Función para enviar respuestas JSON
// function enviarRespuesta($status, $message, $data = [])
// {
//     echo json_encode([
//         'status' => $status,
//         'message' => $message,
//         'data' => $data,
//     ]);
//     exit;
// }

// // Validar que la solicitud sea POST
// if ($_SERVER["REQUEST_METHOD"] !== "POST") {
//     enviarRespuesta("error", "Método no permitido.");
// }

// // Validar que todos los campos estén presentes
// $camposRequeridos = [
//     'id_empleado_externo',
//     'nombre_emp',
//     'user_rfc',
//     'password',
//     'estado',
//     'id_rol',
//     'id_region',
//     'id_puesto',
//     'email'
// ];

// foreach ($camposRequeridos as $campo) {
//     if (empty($_POST[$campo])) {
//         enviarRespuesta("error", "El campo $campo es requerido.");
//     }
// }

// // Sanitizar y validar los datos
// $id_empleado_externo = trim($_POST['id_empleado_externo']);
// $nombre_emp = trim($_POST['nombre_emp']);
// $user_rfc = trim($_POST['user_rfc']);
// $password = trim($_POST['password']);
// $estado = intval($_POST['estado']);
// $id_rol = intval($_POST['id_rol']);
// $id_region = intval($_POST['id_region']);
// $id_puesto = intval($_POST['id_puesto']);
// $email = trim($_POST['email']);



// // Validar RFC
// if (!validarRFC($user_rfc)) {
//     enviarRespuesta("error", "El RFC no tiene un formato válido.");
// }

// // Validar Email
// if (!validarEmail($email)) {
//     enviarRespuesta("error", "El email no tiene un formato válido.");
// }

// // Validar longitud de la contraseña
// if (strlen($password) < 8) {
//     enviarRespuesta("error", "La contraseña debe tener al menos 8 caracteres.");
// }

// try {
//     // Verificar si el ID del empleado ya existe
//     $sql = "SELECT id_empleado_externo, email, user_rfc FROM tbl_empleados WHERE id_empleado_externo = ? OR email = ? OR user_rfc = ?";
//     $stmt = $conexion->prepare($sql);

//     if (!$stmt) {
//         throw new Exception("Error en la preparación de la consulta.");
//     }

//     $stmt->bind_param("sss", $id_empleado_externo, $email, $user_rfc);
//     $stmt->execute();
//     $result = $stmt->get_result();
//     $errores = [];

//     while ($row = $result->fetch_assoc()) {
//         if ($row['id_empleado_externo'] === $id_empleado_externo) {
//             $errores[] = "El ID del empleado externo ya está registrado.";
//         }
//         if ($row['email'] === $email) {
//             $errores[] = "El correo electrónico ya está registrado.";
//         }
//         if ($row['user_rfc'] === $user_rfc) {
//             $errores[] = "El RFC ya está registrado.";
//         }
//     }

//     $stmt->close();

//     if (!empty($errores)) {
//         enviarRespuesta("error", implode(" ", $errores)); // Unir mensajes en una sola respuesta
//     }

//     // Hash de la contraseña
//     $passwordHash = password_hash($password, PASSWORD_BCRYPT);

//     // Insertar el nuevo empleado
//     $sql = "INSERT INTO tbl_empleados (
//                 id_empleado_externo, nombre_emp, user_rfc, password,
//                 estado, id_rol, id_region, id_puesto, email
//             ) VALUES (
//                 ?, ?, ?, ?, ?, ?, ?, ?, ?
//             )";
//     $stmt = $conexion->prepare($sql);
//     if (!$stmt) {
//         throw new Exception("Error en la preparación de la consulta.");
//     }

//     $stmt->bind_param(
//         "ssssiiiss",
//         $id_empleado_externo,
//         $nombre_emp,
//         $user_rfc,
//         $passwordHash,
//         $estado,
//         $id_rol,
//         $id_region,
//         $id_puesto,
//         $email
//     );

//     if ($stmt->execute()) {
//         enviarRespuesta("success", "Empleado registrado correctamente.");
//     } else {
//         throw new Exception("Error al insertar el empleado.");
//     }
// } catch (Exception $e) {
//     enviarRespuesta("error", "Error en el servidor: " . $e->getMessage());
// } finally {
//     if (isset($stmt)) {
//         $stmt->close();
//     }
//     $conexion->close();
// }



// Iniciar sesión
session_start();

// Incluir archivo de configuración para la conexión a MySQL
require '../../config/config.php';

// 🛠️ Configurar conexión persistente
$conexion->options(MYSQLI_OPT_CONNECT_TIMEOUT, 10); // Tiempo máximo de conexión

// Función para validar RFC (México)
function validarRFC($rfc)
{
    $pattern = "/^([A-ZÑ&]{3,4})\\d{6}([A-Z0-9]{3})?$/";
    return preg_match($pattern, strtoupper($rfc));
}

// Función para validar email
function validarEmail($email)
{
    return filter_var($email, FILTER_VALIDATE_EMAIL);
}

// Función para enviar respuestas JSON
function enviarRespuesta($status, $message, $data = [])
{
    echo json_encode([
        'status' => $status,
        'message' => $message,
        'data' => $data,
    ]);
    exit;
}

// Validar que la solicitud sea POST
if ($_SERVER["REQUEST_METHOD"] !== "POST") {
    enviarRespuesta("error", "Método no permitido.");
}

// Validar que todos los campos estén presentes
$camposRequeridos = [
    'id_empleado_externo',
    'nombre_emp',
    'user_rfc',
    'password',
    'estado',
    'id_rol',
    'id_region',
    'id_puesto',
    'email'
];

foreach ($camposRequeridos as $campo) {
    if (!isset($_POST[$campo]) || trim($_POST[$campo]) === '') {
        enviarRespuesta("error", "El campo $campo es requerido.");
    }
}

// Sanitizar y validar los datos
$id_empleado_externo = trim($_POST['id_empleado_externo']);
$nombre_emp = trim($_POST['nombre_emp']);
$user_rfc = trim($_POST['user_rfc']);
$password = trim($_POST['password']);
$estado = trim($_POST['estado']);
$id_rol = intval($_POST['id_rol']);
$id_region = intval($_POST['id_region']);
$id_puesto = intval($_POST['id_puesto']);
$email = trim($_POST['email']);

// Validar RFC
if (!validarRFC($user_rfc)) {
    enviarRespuesta("error", "El RFC no tiene un formato válido.");
}

// Validar Email
if (!validarEmail($email)) {
    enviarRespuesta("error", "El email no tiene un formato válido.");
}

// Validar longitud de la contraseña
if (strlen($password) < 8) {
    enviarRespuesta("error", "La contraseña debe tener al menos 8 caracteres.");
}

try {
    // Verificar si el ID del empleado ya existe
    $sql = "SELECT id_empleado_externo, email, user_rfc FROM tbl_empleados WHERE id_empleado_externo = ? OR email = ? OR user_rfc = ?";
    $stmt = $conexion->prepare($sql);

    if (!$stmt) {
        throw new Exception("Error en la preparación de la consulta.");
    }

    $stmt->bind_param("sss", $id_empleado_externo, $email, $user_rfc);
    $stmt->execute();
    $result = $stmt->get_result();
    $errores = [];

    while ($row = $result->fetch_assoc()) {
        if ($row['id_empleado_externo'] === $id_empleado_externo) {
            $errores[] = "El ID del empleado externo ya está registrado.";
        }
        if ($row['email'] === $email) {
            $errores[] = "El correo electrónico ya está registrado.";
        }
        if ($row['user_rfc'] === $user_rfc) {
            $errores[] = "El RFC ya está registrado.";
        }
    }

    $stmt->close();

    if (!empty($errores)) {
        enviarRespuesta("error", implode(" ", $errores)); // Unir mensajes en una sola respuesta
    }

    // Hash de la contraseña
    $passwordHash = password_hash($password, PASSWORD_BCRYPT);

    // Insertar el nuevo empleado
    $sql = "INSERT INTO tbl_empleados (
                id_empleado_externo, nombre_emp, user_rfc, password,
                estado, id_rol, id_region, id_puesto, email
            ) VALUES (
                ?, ?, ?, ?, ?, ?, ?, ?, ?
            )";
    $stmt = $conexion->prepare($sql);
    if (!$stmt) {
        throw new Exception("Error en la preparación de la consulta.");
    }

    $stmt->bind_param(
        "sssssiiis", // 
        $id_empleado_externo,
        $nombre_emp,
        $user_rfc,
        $passwordHash,
        $estado, // 
        $id_rol,
        $id_region,
        $id_puesto,
        $email
    );

    if ($stmt->execute()) {
        enviarRespuesta("success", "Empleado registrado correctamente.");
    } else {
        throw new Exception("Error al insertar el empleado.");
    }
} catch (Exception $e) {
    enviarRespuesta("error", "Error en el servidor: " . $e->getMessage());
} finally {
    if (isset($stmt)) {
        $stmt->close();
    }
    $conexion->close();
}
