<?php
// // obtener_documentos.php
// require '../../config/config.php'; // Conexión a la BD


// $id_empleado = $_GET['id_empleado']; // Obtener el ID del empleado

// // Configuración para paginación de DataTable
// $limit = isset($_GET['length']) ? $_GET['length'] : 10; // Número de registros por página
// $start = isset($_GET['start']) ? $_GET['start'] : 0; // Offset

// // Consulta para contar el número total de documentos
// $countQuery = "SELECT COUNT(*) AS total FROM tbl_archivos WHERE id_empleado = $id_empleado";
// $countResult = mysqli_query($conexion, $countQuery);
// $totalRecords = mysqli_fetch_assoc($countResult)['total'];

// // Consulta para obtener los documentos con paginación
// $query = "SELECT nombre_archivo, ruta_archivo, fechaPago FROM tbl_archivos WHERE id_empleado = $id_empleado ORDER BY fechaPago DESC LIMIT $start, $limit";
// $result = mysqli_query($conexion, $query);

// // Crear un array para almacenar los resultados
// $data = [];
// while ($row = mysqli_fetch_assoc($result)) {
//     $data[] = $row; // Agregar cada documento al array
// }

// // Retornar los datos en formato JSON para DataTables
// echo json_encode([
//     "draw" => $_GET['draw'], // Número de la solicitud (usado para mantener la sincronización)
//     "recordsTotal" => $totalRecords, // Total de registros sin filtrar
//     "recordsFiltered" => $totalRecords, // Total de registros filtrados
//     "data" => $data // Los datos de los documentos
// ]);


require '../../config/config.php'; // Conexión a la BD

$id_empleado = $_GET['id_empleado']; // Obtener el ID del empleado
$searchValue = $_GET['search']['value']; // Obtener el término de búsqueda

// Configuración para paginación de DataTable
$limit = isset($_GET['length']) ? $_GET['length'] : 10; // Número de registros por página
$start = isset($_GET['start']) ? $_GET['start'] : 0; // Offset

// Inicializar la cláusula WHERE
$whereClause = "WHERE id_empleado = $id_empleado";

// Si hay un término de búsqueda, agregarlo a la cláusula WHERE
if (!empty($searchValue)) {
    $whereClause .= " AND (nombre_archivo LIKE '%$searchValue%' OR fechaPago LIKE '%$searchValue%')";
}

// Consulta para contar el número total de documentos con búsqueda
$countQuery = "SELECT COUNT(*) AS total FROM tbl_archivos $whereClause";
$countResult = mysqli_query($conexion, $countQuery);
$totalRecords = mysqli_fetch_assoc($countResult)['total'];

// Consulta para obtener los documentos con búsqueda y paginación
$query = "SELECT nombre_archivo, ruta_archivo, fechaPago FROM tbl_archivos $whereClause ORDER BY fechaPago DESC LIMIT $start, $limit";
$result = mysqli_query($conexion, $query);

// Crear un array para almacenar los resultados
$data = [];
while ($row = mysqli_fetch_assoc($result)) {
    $data[] = $row; // Agregar cada documento al array
}

// Retornar los datos en formato JSON para DataTables
echo json_encode([
    "draw" => $_GET['draw'], // Número de la solicitud (usado para mantener la sincronización)
    "recordsTotal" => $totalRecords, // Total de registros sin filtrar
    "recordsFiltered" => $totalRecords, // Total de registros filtrados (misma cantidad porque filtramos en la consulta)
    "data" => $data // Los datos de los documentos
]);