<?php



session_start();
header("Cache-Control: no-cache, must-revalidate"); // Evita que se almacene en caché
header("Expires: Sat, 26 Jul 1997 05:00:00 GMT"); // Fecha en el pasado
require '../../config/config.php'; // Conexión a MySQL optimizada

// Configurar conexión persistente con tiempo de espera
$conexion->options(MYSQLI_OPT_CONNECT_TIMEOUT, 10);

function validarRFC($rfc)
{
    $pattern = "/^([A-ZÑ&]{3,4})\\d{6}([A-Z0-9]{3})?$/";
    return preg_match($pattern, strtoupper($rfc));
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $rfc = trim(htmlspecialchars($_POST["rfc_user"]));
    $password = trim($_POST["pass_user"]);

    // 🔹 **Validar RFC antes de hacer la consulta**
    if (!validarRFC($rfc)) {
        echo json_encode(["status" => "error", "message" => "RFC inválido."]);
        exit;
    }

    // 🔹 **Validar que los campos no estén vacíos**
    if (empty($rfc) || empty($password)) {
        echo json_encode(["status" => "error", "message" => "Completa todos los campos."]);
        exit;
    }

    try {
        // 🔹 **Consulta optimizada incluyendo el estado del usuario**
        $sql = "SELECT id_empleado, nombre_emp, user_rfc, password, id_rol, imgUser, id_region, estado 
                FROM tbl_empleados 
                WHERE user_rfc = ? 
                LIMIT 1";
        $stmt = $conexion->prepare($sql);
        if (!$stmt) {
            throw new Exception("Error en la consulta.");
        }

        $stmt->bind_param("s", $rfc);
        $stmt->execute();
        $resultado = $stmt->get_result();

        if ($resultado->num_rows === 1) {
            $usuario = $resultado->fetch_assoc();

            // 🔹 **Verificar si el usuario está inactivo**
            if (strtoupper($usuario["estado"]) !== "ACTIVO") {
                echo json_encode(["status" => "error", "message" => "Usuario inactivo. Contacta al administrador."]);
                exit;
            }

            // 🔹 **Verificación segura de contraseña**
            if (password_verify($password, $usuario["password"])) {
                // 🔹 **Regenerar la sesión de manera segura**
                session_regenerate_id(true);
                $_SESSION["id"] = $usuario["id_empleado"];
                $_SESSION["nombre"] = $usuario["nombre_emp"];
                $_SESSION["rfc"] = $usuario["user_rfc"];
                $_SESSION["rol"] = $usuario["id_rol"];
                $_SESSION['imgUser'] = $usuario['imgUser'];
                $_SESSION['id_region'] = $usuario['id_region'];

                // 🔹 **Redirigir según el rol**
                $redirectUrl = match ($usuario["id_rol"]) {
                    1 => $URL . "/app/view/dashboard/administrador/dashboard.php",
                    2 => $URL . '/app/view/dashboard/empleado/dashboard.php',
                    3 => $URL . '/app/view/dashboard/poa/dashboard.php',
                    4 => $URL . '/app/view/dashboard/coordinador-general/dashboard.php',
                    default => $URL . '/public/index.php',
                };

                echo json_encode(["status" => "success", "message" => "Acceso correcto.", "redirect" => $redirectUrl]);
            } else {
                echo json_encode(["status" => "error", "message" => "Credenciales incorrectas."]);
            }
        } else {
            echo json_encode(["status" => "error", "message" => "RFC no encontrado."]);
        }
    } catch (Exception $e) {
        echo json_encode(["status" => "error", "message" => "Error en el servidor."]);
    } finally {
        if ($stmt) {
            $stmt->close();
        }
        $conexion->close();
    }
}