<?php
// session_start();
// require '../../config/config.php'; // Conexión a la base de datos

// if ($_SERVER['REQUEST_METHOD'] === 'POST') {
//     // Verificar si se recibió un archivo y un ID de usuario
//     if (isset($_FILES['fotoPerfil']) && isset($_POST['iduseFoto'])) {
//         $idUsuario = $_POST['iduseFoto'];
//         $imagen = $_FILES['fotoPerfil'];

//         // Validar que el archivo sea una imagen
//         $permitidos = ['jpg', 'jpeg', 'png', 'gif'];
//         $extension = strtolower(pathinfo($imagen['name'], PATHINFO_EXTENSION));

//         if (in_array($extension, $permitidos)) {
//             // Ruta de la carpeta donde se guardarán las imágenes
//             $carpetaImagenes = 'uploads/imgProfileUser/';

//             // Verificar si la carpeta existe, si no, crearla
//             if (!file_exists($carpetaImagenes)) {
//                 if (!mkdir($carpetaImagenes, 0777, true)) {
//                     echo json_encode(["status" => "error", "message" => "No se pudo crear la carpeta de imágenes."]);
//                     exit;
//                 }
//             }

//             // Crear un nombre único para la imagen
//             $nombreImagen = uniqid('img_', true) . '.' . $extension;
//             $rutaImagen = $carpetaImagenes . $nombreImagen;

//             // Mover la imagen al servidor
//             if (move_uploaded_file($imagen['tmp_name'], $rutaImagen)) {
//                 // Actualizar la ruta de la imagen en la base de datos
//                 $sql = "UPDATE tbl_empleados SET imgUser = ? WHERE id_empleado = ?";
//                 $stmt = $conexion->prepare($sql);
//                 $stmt->bind_param("si", $nombreImagen, $idUsuario);

//                 if ($stmt->execute()) {
//                     echo json_encode(["status" => "success", "message" => "Foto de perfil actualizada correctamente."]);
//                 } else {
//                     echo json_encode(["status" => "error", "message" => "Error al actualizar la foto de perfil."]);
//                 }
//                 $stmt->close();
//             } else {
//                 echo json_encode(["status" => "error", "message" => "Error al subir la imagen."]);
//             }
//         } else {
//             echo json_encode(["status" => "error", "message" => "Formato de imagen no permitido."]);
//         }
//     } else {
//         echo json_encode(["status" => "error", "message" => "Datos incompletos."]);
//     }
// } else {
//     echo json_encode(["status" => "error", "message" => "Método no permitido."]);
// }

error_reporting(E_ALL);
ini_set('display_errors', 1);


/*
session_start();
require '../../config/config.php';

// Verificar método POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Método no permitido"]);
    exit;
}

// Validar datos recibidos
if (!isset($_FILES['fotoPerfil']) || !isset($_POST['iduseFoto'])) {
    echo json_encode(["status" => "error", "message" => "Datos incompletos"]);
    exit;
}

$idUsuario = $_POST['iduseFoto'];
$imagen = $_FILES['fotoPerfil'];

// Validar extensión
$extension = strtolower(pathinfo($imagen['name'], PATHINFO_EXTENSION));
if (!in_array($extension, ['jpg', 'jpeg', 'png'])) {
    echo json_encode(["status" => "error", "message" => "Formato no permitido. Sube JPG o PNG"]);
    exit;
}

// Validar tamaño (10MB)
if ($imagen['size'] > 10 * 1024 * 1024) {
    echo json_encode(["status" => "error", "message" => "La imagen excede el límite de 10MB"]);
    exit;
}

// Ruta de almacenamiento
$carpetaImagenes = 'uploads/imgProfileUser/';
if (!file_exists($carpetaImagenes)) {
    mkdir($carpetaImagenes, 0755, true);
}

// Obtener imagen actual SIN eliminarla todavía
$sql = "SELECT imgUser FROM tbl_empleados WHERE id_empleado = ?";
$stmt = $conexion->prepare($sql);
$stmt->bind_param("i", $idUsuario);
$stmt->execute();
$stmt->bind_result($imagenActual);
$stmt->fetch();
$stmt->close();

// Generar nombre único para la nueva imagen
$nombreImagen = uniqid('img_', true) . '.' . $extension;
$rutaImagen = $carpetaImagenes . $nombreImagen;

// Intentar mover la imagen nueva antes de tocar la anterior
if (!move_uploaded_file($imagen['tmp_name'], $rutaImagen)) {
    echo json_encode(["status" => "error", "message" => "Error al guardar la imagen en el servidor"]);
    exit;
}

// Iniciar transacción para seguridad
$conexion->begin_transaction();

// Intentar actualizar la base de datos
$sql = "UPDATE tbl_empleados SET imgUser = ? WHERE id_empleado = ?";
$stmt = $conexion->prepare($sql);
$stmt->bind_param("si", $nombreImagen, $idUsuario);

if ($stmt->execute()) {
    // Confirmar cambios en la BD
    $conexion->commit();

    // Ahora sí, eliminar la imagen anterior si existe
    if ($imagenActual && file_exists($carpetaImagenes . $imagenActual)) {
        unlink($carpetaImagenes . $imagenActual);
    }

    $_SESSION['imgUser'] = $nombreImagen;
    echo json_encode(["status" => "success", "message" => "Foto de perfil actualizada"]);
} else {
    // Si falla la BD, borrar la nueva imagen para no dejar archivos huérfanos
    unlink($rutaImagen);
    $conexion->rollback();
    echo json_encode(["status" => "error", "message" => "Error al actualizar la base de datos"]);
}

$stmt->close();*/



session_start();
require '../../config/config.php';

// Configuración
$carpetaImagenes = 'uploads/imgProfileUser/';
$maxFileSize = 20 * 1024 * 1024; // 20MB (ajustado al límite del servidor)
$allowedExtensions = ['jpg', 'jpeg', 'png'];

// Funciones de utilidad
function sendJson($status, $message) {
    header('Content-Type: application/json');
    echo json_encode(["status" => $status, "message" => $message]);
    exit;
}

// Verificar método POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendJson('error', 'Método no permitido');
}

// Validar datos recibidos
if (!isset($_FILES['fotoPerfil']) || !isset($_POST['iduseFoto'])) {
    sendJson('error', 'Datos incompletos');
}

$idUsuario = $_POST['iduseFoto'];
$imagen = $_FILES['fotoPerfil'];

// Validar si hay errores en la carga
if ($imagen['error'] !== UPLOAD_ERR_OK) {
    switch ($imagen['error']) {
        case UPLOAD_ERR_INI_SIZE:
        case UPLOAD_ERR_FORM_SIZE:
            sendJson('error', 'La imagen excede el tamaño permitido (2MB)');
        default:
            sendJson('error', 'Error al cargar la imagen');
    }
}

// Validar tamaño
if ($imagen['size'] > $maxFileSize) {
    sendJson('error', 'La imagen excede el límite de 20MB');
}

// Validar extensión
$extension = strtolower(pathinfo($imagen['name'], PATHINFO_EXTENSION));
if (!in_array($extension, $allowedExtensions)) {
    sendJson('error', 'Formato no permitido. Sube JPG, JPEG o PNG');
}

// Crear directorio si no existe
if (!file_exists($carpetaImagenes)) {
    if (!mkdir($carpetaImagenes, 0755, true)) {
        sendJson('error', 'Error al crear el directorio de imágenes');
    }
}

// Obtener imagen actual (optimizado)
$sql = "SELECT imgUser FROM tbl_empleados WHERE id_empleado = ?";
$stmt = $conexion->prepare($sql);
$stmt->bind_param("i", $idUsuario);
$stmt->execute();
$stmt->bind_result($imagenActual);
$stmt->fetch();
$stmt->close();

// Generar nombre único
$nombreImagen = uniqid('img_', true) . '.' . $extension;
$rutaImagen = $carpetaImagenes . $nombreImagen;

// Mover archivo (validación adicional)
if (!is_uploaded_file($imagen['tmp_name']) || !move_uploaded_file($imagen['tmp_name'], $rutaImagen)) {
    sendJson('error', 'Error al guardar la imagen');
}

// Transacción
$conexion->begin_transaction();

$sql = "UPDATE tbl_empleados SET imgUser = ? WHERE id_empleado = ?";
$stmt = $conexion->prepare($sql);
$stmt->bind_param("si", $nombreImagen, $idUsuario);

if ($stmt->execute()) {
    $conexion->commit();

    // Eliminar imagen anterior (optimizado)
    if ($imagenActual && file_exists($carpetaImagenes . $imagenActual)) {
        if (!unlink($carpetaImagenes . $imagenActual)) {
            // Log de error (opcional)
            error_log("No se pudo eliminar la imagen anterior: " . $carpetaImagenes . $imagenActual);
        }
    }

    $_SESSION['imgUser'] = $nombreImagen;
    sendJson('success', 'Foto de perfil actualizada');
} else {
    unlink($rutaImagen); // Limpiar nueva imagen
    $conexion->rollback();
    sendJson('error', 'Error al actualizar la base de datos');
}

$stmt->close();
$conexion->close();
?>



