<?php
require '../../config/config.php'; // Conexión a MySQLi

// Verifica que la solicitud sea POST y que se haya enviado un archivo
if ($_SERVER["REQUEST_METHOD"] !== "POST" || !isset($_FILES["zipFile"])) {
    respuestaJSON("error", "Método no permitido o archivo no enviado.");
}

// Recibe los datos del formulario
$usuarioID = $_POST['searchInputID'] ?? null;
$fechaPago = $_POST['fechaPago'] ?? null;

// Validaciones iniciales
if (!$usuarioID || !$fechaPago) {
    respuestaJSON("error", "Faltan datos obligatorios.");
}

// Consulta el RFC del empleado
$query = "SELECT user_rfc FROM tbl_empleados WHERE id_empleado = ?";
$stmt = $conexion->prepare($query);
$stmt->bind_param("i", $usuarioID);
$stmt->execute();
$result = $stmt->get_result();
$empleado = $result->fetch_assoc();

if (!$empleado) {
    respuestaJSON("error", "El empleado seleccionado no existe.");
}

$rfcuser = $empleado['user_rfc'];

// Crear subcarpetas basadas en la fecha de pago
$fechaPagoFormato = date('Y/m/d', strtotime($fechaPago)); // Formato: YYYY/MM/DD
$uploadDir = 'uploads/' . $fechaPagoFormato . '/';

if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0777, true); // Crear subcarpetas si no existen
}

// Obtener datos del archivo ZIP
$file = $_FILES['zipFile'];
$fileTmpPath = $file['tmp_name'];
$fileName = $file['name'];
$fileSize = $file['size'];
$fileError = $file['error'];
$fileExt = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

// Verifica errores en la subida
if ($fileError !== UPLOAD_ERR_OK) {
    respuestaJSON("error", "Error al subir el archivo.");
}

// Verifica si el archivo es un ZIP
if ($fileExt !== "zip") {
    respuestaJSON("error", "El archivo debe ser un ZIP.");
}

// Límite de tamaño (10MB)
$maxFileSize = 10 * 1024 * 1024;
if ($fileSize > $maxFileSize) {
    respuestaJSON("error", "El archivo excede el tamaño máximo permitido (10MB).");
}

// Nombre del archivo ZIP: RFC_FECHAPAGO.zip
$newFileName = $rfcuser . "_" . str_replace("-", "", $fechaPago) . ".zip";
$filePath = $uploadDir . $newFileName;

// Mueve el archivo a la carpeta destino
if (!move_uploaded_file($fileTmpPath, $filePath)) {
    respuestaJSON("error", "Error al mover el archivo ZIP.");
}

// Guarda en la base de datos
$fechaSubida = date("Y-m-d H:i:s");
$sql = "INSERT INTO tbl_archivos (id_empleado, nombre_archivo, ruta_archivo, fechaPago, fecha_subida) 
        VALUES (?, ?, ?, ?, ?)";
$stmt = $conexion->prepare($sql);
$stmt->bind_param("issss", $usuarioID, $newFileName, $filePath, $fechaPago, $fechaSubida);
$stmt->execute();

// Responder con éxito
respuestaJSON("success", "Archivo ZIP subido correctamente.", ["archivo" => $filePath]);

// Función para enviar respuestas JSON
function respuestaJSON($status, $message, $data = [])
{
    echo json_encode(array_merge(["status" => $status, "message" => $message], $data));
    exit;
}