<?php
require '../../config/config.php'; // Conexión a MySQLi


echo "POST_MAX_SIZE: " . ini_get('post_max_size') . "\n";
echo "UPLOAD_MAX_FILESIZE: " . ini_get('upload_max_filesize') . "\n";
echo "MAX_FILE_UPLOADS: " . ini_get('max_file_uploads') . "\n";


// 1. Activar visualización de errores (solo para desarrollo)
ini_set('display_errors', 1);
error_reporting(E_ALL);

// 2. Crear archivo de log para depuración
file_put_contents('debug.log', "\n\n".date('Y-m-d H:i:s')." - Nueva solicitud\n", FILE_APPEND);

// 3. Imprimir datos recibidos (POST y FILES)
file_put_contents('debug.log', "Datos POST recibidos:\n".print_r($_POST, true)."\n", FILE_APPEND);
file_put_contents('debug.log', "Archivos recibidos:\n".print_r($_FILES, true)."\n", FILE_APPEND);

// 4. Respuesta temporal para depuración (comenta esto después de probar)
respuestaJSON("debug", "Datos recibidos para depuración", [
    'post_data' => $_POST,
    'files_data' => $_FILES,
    'server_info' => [
        'request_method' => $_SERVER['REQUEST_METHOD'],
        'content_type' => $_SERVER['CONTENT_TYPE'] ?? 'No definido'
    ]
]);
// exit; // Descomenta esta línea si solo quieres ver los datos recibidos








// Verifica que la solicitud sea POST y que se hayan enviado archivos
if ($_SERVER["REQUEST_METHOD"] !== "POST" || !isset($_FILES["pdfFiles"])) {
    respuestaJSON("error", "Método no permitido o archivos no enviados.");
}

// Verifica si $_FILES['pdfFiles']['name'] es un array
if (!is_array($_FILES['pdfFiles']['name'])) {
    respuestaJSON("error", "No se han enviado archivos correctamente.");
}

// Recibe los datos del formulario
$usuarioID = $_POST['searchInputID'] ?? null;
$fechaPago = $_POST['fechaPago'] ?? null;

// Validaciones iniciales
if (!$usuarioID || !$fechaPago) {
    respuestaJSON("error", "Faltan datos obligatorios.");
}

// Consulta el RFC del empleado
$query = "SELECT user_rfc FROM tbl_empleados WHERE id_empleado = ?";
$stmt = $conexion->prepare($query);
$stmt->bind_param("i", $usuarioID);
$stmt->execute();
$result = $stmt->get_result();
$empleado = $result->fetch_assoc();

if (!$empleado) {
    respuestaJSON("error", "El empleado seleccionado no existe.");
}

$rfcuser = $empleado['user_rfc'];

// Verificar archivos ya subidos
$query = "SELECT COUNT(*) as total, 
                 SUM(CASE WHEN nombre_archivo LIKE '%.pdf' THEN 1 ELSE 0 END) as total_pdfs,
                 SUM(CASE WHEN nombre_archivo LIKE '%.xml' THEN 1 ELSE 0 END) as total_xmls
          FROM tbl_archivos 
          WHERE id_empleado = ? AND fechaPago = ?";
$stmt = $conexion->prepare($query);
$stmt->bind_param("is", $usuarioID, $fechaPago);
$stmt->execute();
$result = $stmt->get_result();
$archivosExistentes = $result->fetch_assoc();

$totalActual = $archivosExistentes['total'];
$totalPDFs = $archivosExistentes['total_pdfs'];
$totalXMLs = $archivosExistentes['total_xmls'];

if ($totalActual >= 4) {
    respuestaJSON("error", "Este empleado ya tiene los 4 documentos requeridos.");
}

// Crear subcarpetas basadas en la fecha de pago
$fechaPagoFormato = date('Y/m/d', strtotime($fechaPago)); // Formato: YYYY/MM/DD
$uploadDir = '../../uploads/' . $fechaPagoFormato . '/';

if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0777, true); // Crear subcarpetas si no existen
}

$files = $_FILES['pdfFiles'];
$uploadedFiles = [];
$maxFileSize = 5 * 1024 * 1024; // 5MB
$fechaSubida = date("Y-m-d H:i:s");

try {
    $conexion->begin_transaction(); // Iniciar transacción

    for ($i = 0; $i < count($files['name']); $i++) {
        $fileTmpPath = $files['tmp_name'][$i];
        $fileName = $files['name'][$i];
        $fileSize = $files['size'][$i];
        $fileError = $files['error'][$i];

        // Verifica errores en la subida
        if ($fileError !== UPLOAD_ERR_OK) {
            throw new Exception("Error al subir el archivo: " . $fileName);
        }

        // Verifica si el archivo es un PDF o un XML
        $mimeType = mime_content_type($fileTmpPath);
        if ($mimeType !== 'application/pdf' && $mimeType !== 'text/xml') {
            throw new Exception("El archivo " . $fileName . " no es un PDF o XML válido.");
        }

        // Verifica el tamaño del archivo
        if ($fileSize > $maxFileSize) {
            throw new Exception("El archivo " . $fileName . " excede el tamaño máximo permitido (5MB).");
        }

        // Validar la cantidad permitida de PDFs y XMLs
        if ($mimeType === 'application/pdf' && $totalPDFs >= 2) {
            throw new Exception("Ya se han subido los 2 archivos PDF requeridos.");
        }
        if ($mimeType === 'text/xml' && $totalXMLs >= 2) {
            throw new Exception("Ya se han subido los 2 archivos XML requeridos.");
        }

        // Generar nombre único para el archivo
        $timestamp = time();
        $newFileName = $rfcuser . "_" . str_replace("-", "", $fechaPago) . "_$timestamp." . pathinfo($fileName, PATHINFO_EXTENSION);
        $filePath = $uploadDir . $newFileName;

        // Mueve el archivo a la carpeta destino
        if (!move_uploaded_file($fileTmpPath, $filePath)) {
            throw new Exception("Error al mover el archivo " . $fileName);
        }

        // Guarda en la base de datos
        $sql = "INSERT INTO tbl_archivos (id_empleado, nombre_archivo, ruta_archivo, fechaPago, fecha_subida) 
                VALUES (?, ?, ?, ?, ?)";
        $stmt = $conexion->prepare($sql);
        $stmt->bind_param("issss", $usuarioID, $newFileName, $filePath, $fechaPago, $fechaSubida);
        $stmt->execute();

        $uploadedFiles[] = $filePath; // Agrega la ruta del archivo a la lista de subidos

        // Incrementar el contador de archivos según el tipo
        if ($mimeType === 'application/pdf') {
            $totalPDFs++;
        } else {
            $totalXMLs++;
        }
    }

    $conexion->commit(); // Confirmar la transacción
    respuestaJSON("success", "Archivos subidos con éxito.", ["files" => $uploadedFiles]);
} catch (Exception $e) {
    $conexion->rollback(); // Revertir la transacción si hubo error
    respuestaJSON("error", $e->getMessage());
}

// Función para enviar respuestas JSON
function respuestaJSON($status, $message, $data = [])
{
    echo json_encode(array_merge(["status" => $status, "message" => $message], $data));
    exit;
}
