<?php
// require '../../config/config.php';

// if ($_SERVER['REQUEST_METHOD'] === 'POST') {
//     // Obtener datos enviados
//     $id_empleado = $_POST['searchInputID'] ?? null;
//     $id_region = $_POST['searchInputIDRegion'] ?? null;

//     // Validar datos obligatorios
//     if (!$id_empleado || !$id_region) {
//         echo json_encode(["status" => "error", "message" => "Faltan datos obligatorios."]);
//         exit;
//     }

//     // Definir el directorio donde se guardarán los archivos
//     $directorio = "../../uploads/docs_usuarios/region_$id_region/usuario_$id_empleado/";

//     // Verificar si la carpeta existe, si no, crearla con permisos seguros
//     if (!is_dir($directorio) && !mkdir($directorio, 0755, true)) {
//         echo json_encode(["status" => "error", "message" => "No se pudo crear el directorio de almacenamiento."]);
//         exit;
//     }

//     // Tipos de archivos permitidos
//     $archivos = ['contrato', 'afiliacion', 'baja'];
//     $datos_insert = ["contrato" => null, "afiliacion" => null, "baja" => null];
//     $errores = [];

//     foreach ($archivos as $archivo) {
//         if (!empty($_FILES[$archivo]['name'])) {
//             $nombreArchivo = basename($_FILES[$archivo]['name']);
//             $tipoArchivo = strtolower(pathinfo($nombreArchivo, PATHINFO_EXTENSION));

//             // Validar que sea un archivo PDF
//             if ($tipoArchivo !== 'pdf') {
//                 $errores[] = "El archivo $archivo debe ser un PDF.";
//                 continue;
//             }

//             // Definir la ruta final del archivo
//             $rutaArchivo = $directorio . $id_empleado . "_" . $archivo . ".pdf";

//             // Mover el archivo al directorio final
//             if (move_uploaded_file($_FILES[$archivo]['tmp_name'], $rutaArchivo)) {
//                 $datos_insert[$archivo] = $rutaArchivo;
//             } else {
//                 $errores[] = "Error al subir el archivo $archivo.";
//             }
//         }
//     }

//     // Si al menos un archivo fue subido correctamente, actualizar la BD
//     if (!empty(array_filter($datos_insert))) {

//         // Consulta SQL con `ON DUPLICATE KEY UPDATE`
//         $query = "INSERT INTO tbl_doc_empl (id_empleado, contrato, afiliacion, baja) 
//                   VALUES (?, ?, ?, ?) 
//                   ON DUPLICATE KEY UPDATE 
//                   contrato = VALUES(contrato), 
//                   afiliacion = VALUES(afiliacion), 
//                   baja = VALUES(baja)";

//         $stmt = $conexion->prepare($query);
//         if (!$stmt) {
//             echo json_encode(["status" => "error", "message" => "Error en la consulta: " . $conexion->error]);
//             exit;
//         }

//         $stmt->bind_param(
//             "isss",
//             $id_empleado,
//             $datos_insert['contrato'],
//             $datos_insert['afiliacion'],
//             $datos_insert['baja']
//         );

//         if ($stmt->execute()) {
//             $status = empty($errores) ? "success" : "warning";
//             $message = empty($errores) ? "Documentos subidos con éxito." : implode(' ', $errores);
//         } else {
//             $status = "error";
//             $message = "Error al guardar en la base de datos: " . $stmt->error;
//         }

//         $stmt->close();
//         $conexion->close();

//         echo json_encode(["status" => $status, "message" => $message]);
//         exit;
//     }

//     // Si no se subió ningún archivo correctamente
//     echo json_encode(["status" => "error", "message" => implode(' ', $errores)]);
//     exit;
// }



require '../../config/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    set_time_limit(30); // Máximo de 30 segundos de ejecución

    $id_empleado = $_POST['searchInputID'] ?? null;
    $id_region = $_POST['searchInputIDRegion'] ?? null;

    // Validar datos obligatorios
    if (!$id_empleado || !$id_region) {
        echo json_encode(["status" => "error", "message" => "Faltan datos obligatorios."]);
        exit;
    }

    // Verificar si el usuario ya tiene documentos asignados
    $checkQuery = "SELECT id FROM tbl_doc_empl WHERE id_empleado = ?";
    $stmt = $conexion->prepare($checkQuery);
    $stmt->bind_param("i", $id_empleado);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        echo json_encode(["status" => "warning", "message" => "El usuario ya tiene documentos asignados."]);
        exit;
    }
    $stmt->close();

    // Definir el directorio de almacenamiento
    $directorio = "../../uploads/docs_usuarios/usuario_$id_empleado/";

    // Crear el directorio si no existe
    if (!is_dir($directorio) && !mkdir($directorio, 0755, true)) {
        echo json_encode(["status" => "error", "message" => "No se pudo crear el directorio de almacenamiento."]);
        exit;
    }

    // Tipos de archivos permitidos
    $archivos = ['contrato', 'afiliacion', 'baja'];
    $datos_insert = ["contrato" => null, "afiliacion" => null, "baja" => null];
    $errores = [];
    $archivosSubidos = [];

    foreach ($archivos as $archivo) {
        if (!empty($_FILES[$archivo]['name'])) {
            $nombreArchivo = basename($_FILES[$archivo]['name']);
            $tipoArchivo = strtolower(pathinfo($nombreArchivo, PATHINFO_EXTENSION));
            $tamañoArchivo = $_FILES[$archivo]['size'];

            // Validar tipo de archivo (solo PDF)
            if ($tipoArchivo !== 'pdf') {
                $errores[] = "El archivo '$archivo' debe ser un PDF.";
                continue;
            }

            // Validar tamaño del archivo (5MB máximo)
            if ($tamañoArchivo > 5 * 1024 * 1024) {
                $errores[] = "El archivo '$archivo' excede el tamaño máximo de 5MB.";
                continue;
            }

            // Definir ruta de almacenamiento
            $rutaArchivo = $directorio . $id_empleado . "_" . $archivo . ".pdf";

            // Intentar mover el archivo
            if (move_uploaded_file($_FILES[$archivo]['tmp_name'], $rutaArchivo)) {
                $datos_insert[$archivo] = $rutaArchivo;
                $archivosSubidos[] = $rutaArchivo;
            } else {
                $errores[] = "Error al subir el archivo '$archivo'.";
            }
        }
    }

    // Si no se subió ningún archivo correctamente, eliminar directorio y salir
    if (empty(array_filter($datos_insert))) {
        foreach ($archivosSubidos as $archivo) {
            unlink($archivo); // Eliminar archivos subidos si hubo errores
        }
        echo json_encode(["status" => "error", "message" => implode(' ', $errores)]);
        exit;
    }

    // Insertar en la base de datos
    $query = "INSERT INTO tbl_doc_empl (id_empleado, contrato, afiliacion, baja) 
              VALUES (?, ?, ?, ?)";

    $stmt = $conexion->prepare($query);
    if (!$stmt) {
        echo json_encode(["status" => "error", "message" => "Error en la consulta: " . $conexion->error]);
        exit;
    }

    $stmt->bind_param(
        "isss",
        $id_empleado,
        $datos_insert['contrato'],
        $datos_insert['afiliacion'],
        $datos_insert['baja']
    );

    if ($stmt->execute()) {
        $status = empty($errores) ? "success" : "warning";
        $message = empty($errores) ? "Documentos subidos con éxito." : implode(' ', $errores);
    } else {
        // En caso de fallo, eliminar los archivos ya subidos
        foreach ($archivosSubidos as $archivo) {
            unlink($archivo);
        }
        $status = "error";
        $message = "Error al guardar en la base de datos: " . $stmt->error;
    }

    $stmt->close();
    $conexion->close();

    echo json_encode(["status" => $status, "message" => $message]);
    exit;
}
