<?php
// require '../../config/config.php'; // Conexión a MySQLi

// // Verifica que la solicitud sea POST y que se hayan enviado archivos
// if ($_SERVER["REQUEST_METHOD"] !== "POST" || !isset($_FILES["nuevoArchivo"])) {
//     respuestaJSON("error", "Método no permitido o archivos no enviados.");
// }

// // Recibe los datos del formulario
// $idArchivo = $_POST['idArchivo'] ?? null;
// $usuarioID = $_POST['usuarioID'] ?? null;
// $fechaPago = $_POST['fechaPago'] ?? null;

// // Validaciones iniciales
// if (!$idArchivo || !$usuarioID || !$fechaPago) {
//     respuestaJSON("error", "Faltan datos obligatorios." . $idArchivo . $usuarioID . $fechaPago);
// }

// // Consulta la información del archivo actual
// $query = "SELECT id_empleado, nombre_archivo, ruta_archivo FROM tbl_archivos WHERE id_archivo = ?";
// $stmt = $conexion->prepare($query);
// $stmt->bind_param("i", $idArchivo);
// $stmt->execute();
// $result = $stmt->get_result();
// $archivo = $result->fetch_assoc();

// // Validar que el archivo exista
// if (!$archivo) {
//     respuestaJSON("error", "El archivo no existe.");
// }

// // Verificar que el archivo pertenece al usuario correcto
// if ($archivo['id_empleado'] != $usuarioID) {
//     respuestaJSON("error", "No tienes permisos para modificar este archivo.");
// }

// // Obtener el nombre del empleado
// $query = "SELECT nombre_emp FROM tbl_empleados WHERE id_empleado = ?";
// $stmt = $conexion->prepare($query);
// $stmt->bind_param("i", $usuarioID);
// $stmt->execute();
// $result = $stmt->get_result();
// $empleado = $result->fetch_assoc();

// if (!$empleado) {
//     respuestaJSON("error", "El empleado no existe.");
// }

// $nombreEmpleado = preg_replace("/[^a-zA-Z0-9]/", "_", $empleado['nombre_emp']); // Sanitiza nombre

// // Crear subcarpetas basadas en la fecha de pago
// $fechaPagoFormato = date('Y/m/d', strtotime($fechaPago));
// $uploadDir = 'uploads/' . $fechaPagoFormato . '/';

// if (!is_dir($uploadDir)) {
//     mkdir($uploadDir, 0777, true);
// }

// // Validaciones del nuevo archivo
// $maxFileSize = 5 * 1024 * 1024; // 5MB
// $nuevoArchivo = $_FILES['nuevoArchivo'];
// $fileTmpPath = $nuevoArchivo['tmp_name'];
// $fileName = $nuevoArchivo['name'];
// $fileSize = $nuevoArchivo['size'];
// $fileError = $nuevoArchivo['error'];

// // Verifica errores en la subida
// if ($fileError !== UPLOAD_ERR_OK) {
//     respuestaJSON("error", "Error al subir el archivo.");
// }

// // Verifica si el archivo es un PDF o XML
// $mimeType = mime_content_type($fileTmpPath);
// if ($mimeType !== 'application/pdf' && $mimeType !== 'text/xml') {
//     respuestaJSON("error", "El archivo no es un PDF o XML válido.");
// }

// // Verifica el tamaño del archivo
// if ($fileSize > $maxFileSize) {
//     respuestaJSON("error", "El archivo excede el tamaño máximo permitido (5MB).");
// }

// // Generar nombre único para el archivo
// $timestamp = time();
// $newFileName = $nombreEmpleado . "_" . str_replace("-", "", $fechaPago) . "_$timestamp." . pathinfo($fileName, PATHINFO_EXTENSION);
// $filePath = $uploadDir . $newFileName;

// try {
//     $conexion->begin_transaction(); // Iniciar transacción

//     // Eliminar el archivo anterior
//     if (file_exists($archivo['ruta_archivo'])) {
//         unlink($archivo['ruta_archivo']);
//     }

//     // Mueve el nuevo archivo
//     if (!move_uploaded_file($fileTmpPath, $filePath)) {
//         throw new Exception("Error al mover el nuevo archivo.");
//     }

//     // Actualizar la base de datos con la nueva ruta
//     $fechaSubida = date("Y-m-d H:i:s");
//     $sql = "UPDATE tbl_archivos SET nombre_archivo = ?, ruta_archivo = ?, fechaPago = ?, fecha_subida = ? WHERE id_archivo = ?";
//     $stmt = $conexion->prepare($sql);
//     $stmt->bind_param("ssssi", $newFileName, $filePath, $fechaPago, $fechaSubida, $idArchivo);
//     $stmt->execute();

//     $conexion->commit(); // Confirmar la transacción
//     respuestaJSON("success", "Archivo actualizado con éxito.", ["ruta" => $filePath]);
// } catch (Exception $e) {
//     $conexion->rollback(); // Revertir la transacción si hubo error
//     respuestaJSON("error", $e->getMessage());
// }

// // Función para enviar respuestas JSON
// function respuestaJSON($status, $message, $data = [])
// {
//     echo json_encode(array_merge(["status" => $status, "message" => $message], $data));
//     exit;
// }




// require '../../config/config.php'; // Conexión a MySQLi

// // Verifica que la solicitud sea POST
// if ($_SERVER["REQUEST_METHOD"] !== "POST") {
//     respuestaJSON("error", "Método no permitido.");
// }

// // Recibe los datos del formulario
// $idArchivo  = $_POST['idArchivo'] ?? null;
// $usuarioID  = $_POST['usuarioID'] ?? null;
// $fechaPago  = $_POST['fechaPago'] ?? null;
// $nuevoArchivo = $_FILES['nuevoArchivo'] ?? null;

// // Validación inicial
// if (!$idArchivo || !$usuarioID) {
//     respuestaJSON("error", "Faltan datos obligatorios.");
// }

// // Consulta la información actual del archivo
// $query = "SELECT id_empleado, nombre_archivo, ruta_archivo FROM tbl_archivos WHERE id_archivo = ?";
// $stmt = $conexion->prepare($query);
// $stmt->bind_param("i", $idArchivo);
// $stmt->execute();
// $result = $stmt->get_result();
// $archivoActual = $result->fetch_assoc();

// if (!$archivoActual) {
//     respuestaJSON("error", "El archivo no existe.");
// }

// // Verificar que el usuario tiene permisos para modificar el archivo
// if ($archivoActual['id_empleado'] != $usuarioID) {
//     respuestaJSON("error", "No tienes permisos para modificar este archivo.");
// }

// // Construcción dinámica del SQL
// $updateFields = [];
// $params = [];
// $types = "";

// // Si se envió una nueva fecha de pago
// if (!empty($fechaPago)) {
//     $updateFields[] = "fechaPago = ?";
//     $params[] = $fechaPago;
//     $types .= "s";
// }

// // Si se subió un nuevo archivo
// if ($nuevoArchivo && $nuevoArchivo['error'] === UPLOAD_ERR_OK) {
//     $maxFileSize = 5 * 1024 * 1024; // 5MB
//     $fileTmpPath = $nuevoArchivo['tmp_name'];
//     $fileName = $nuevoArchivo['name'];
//     $fileSize = $nuevoArchivo['size'];

//     // Validación del tipo de archivo
//     $mimeType = mime_content_type($fileTmpPath);
//     if (!in_array($mimeType, ['application/pdf', 'text/xml'])) {
//         respuestaJSON("error", "Solo se permiten archivos PDF o XML.");
//     }

//     // Validación del tamaño del archivo
//     if ($fileSize > $maxFileSize) {
//         respuestaJSON("error", "El archivo excede el tamaño máximo permitido (5MB).");
//     }

//     // Obtener el nombre del empleado
//     $query = "SELECT nombre_emp FROM tbl_empleados WHERE id_empleado = ?";
//     $stmt = $conexion->prepare($query);
//     $stmt->bind_param("i", $usuarioID);
//     $stmt->execute();
//     $result = $stmt->get_result();
//     $empleado = $result->fetch_assoc();

//     if (!$empleado) {
//         respuestaJSON("error", "El empleado no existe.");
//     }

//     $nombreEmpleado = preg_replace("/[^a-zA-Z0-9]/", "_", $empleado['nombre_emp']); // Sanitiza nombre
//     $fechaPagoFormato = date('Y/m/d', strtotime($fechaPago));
//     $uploadDir = 'uploads/' . $fechaPagoFormato . '/';

//     // Crear carpeta si no existe
//     if (!is_dir($uploadDir)) {
//         mkdir($uploadDir, 0777, true);
//     }

//     // Generar nuevo nombre único para el archivo
//     $timestamp = time();
//     $newFileName = $nombreEmpleado . "_" . str_replace("-", "", $fechaPago) . "_$timestamp." . pathinfo($fileName, PATHINFO_EXTENSION);
//     $filePath = $uploadDir . $newFileName;

//     try {
//         $conexion->begin_transaction(); // Iniciar transacción

//         // Eliminar el archivo anterior si existe
//         if (file_exists($archivoActual['ruta_archivo'])) {
//             unlink($archivoActual['ruta_archivo']);
//         }

//         // Mover el nuevo archivo
//         if (!move_uploaded_file($fileTmpPath, $filePath)) {
//             throw new Exception("Error al mover el nuevo archivo.");
//         }

//         // Agregar la nueva ruta al SQL dinámico
//         $updateFields[] = "nombre_archivo = ?, ruta_archivo = ?";
//         $params[] = $newFileName;
//         $params[] = $filePath;
//         $types .= "ss";
//     } catch (Exception $e) {
//         $conexion->rollback();
//         respuestaJSON("error", $e->getMessage());
//     }
// }

// // Verificar si hay datos para actualizar
// if (empty($updateFields)) {
//     respuestaJSON("error", "No se enviaron cambios para actualizar.");
// }

// // Agregar el WHERE
// $updateFields[] = "fecha_subida = NOW()"; // Agregar fecha de actualización
// $updateSQL = "UPDATE tbl_archivos SET " . implode(", ", $updateFields) . " WHERE id_archivo = ?";
// $params[] = $idArchivo;
// $types .= "i";

// // Preparar y ejecutar el SQL
// $stmt = $conexion->prepare($updateSQL);
// $stmt->bind_param($types, ...$params);

// if ($stmt->execute()) {
//     $conexion->commit();
//     respuestaJSON("success", "Archivo actualizado con éxito.", ["ruta" => $filePath ?? $archivoActual['ruta_archivo']]);
// } else {
//     $conexion->rollback();
//     respuestaJSON("error", "Error al actualizar los datos.");
// }

// // Función para enviar respuestas JSON
// function respuestaJSON($status, $message, $data = [])
// {
//     echo json_encode(array_merge(["status" => $status, "message" => $message], $data));
//     exit;
// }



// require '../../config/config.php'; // Conexión a MySQLi

// // Verifica que la solicitud sea POST
// if ($_SERVER["REQUEST_METHOD"] !== "POST") {
//     respuestaJSON("error", "Método no permitido.");
// }

// // Recibe los datos del formulario
// $idArchivo  = $_POST['idArchivo'] ?? null;
// $usuarioID  = $_POST['usuarioID'] ?? null;
// $fechaPago  = $_POST['fechaPago'] ?? null;
// $nuevoArchivo = $_FILES['nuevoArchivo'] ?? null;

// // Validación inicial
// if (!$idArchivo || !$usuarioID) {
//     respuestaJSON("error", "Faltan datos obligatorios.");
// }

// // Consulta la información actual del archivo
// $query = "SELECT id_empleado, nombre_archivo, ruta_archivo, fechaPago FROM tbl_archivos WHERE id_archivo = ?";
// $stmt = $conexion->prepare($query);
// $stmt->bind_param("i", $idArchivo);
// $stmt->execute();
// $result = $stmt->get_result();
// $archivoActual = $result->fetch_assoc();

// if (!$archivoActual) {
//     respuestaJSON("error", "El archivo no existe.");
// }

// // Verificar que el usuario tiene permisos para modificar el archivo
// if ($archivoActual['id_empleado'] != $usuarioID) {
//     respuestaJSON("error", "No tienes permisos para modificar este archivo.");
// }

// // Construcción dinámica del SQL
// $updateFields = [];
// $params = [];
// $types = "";

// // Se necesita actualizar la ubicación del archivo si la fecha de pago cambió
// $fechaPagoNueva = !empty($fechaPago) ? date('Y/m/d', strtotime($fechaPago)) : $archivoActual['fechaPago'];
// $fechaPagoAntigua = date('Y/m/d', strtotime($archivoActual['fechaPago']));

// $moverArchivo = ($fechaPagoNueva !== $fechaPagoAntigua);

// // Obtener el nombre del empleado
// $query = "SELECT nombre_emp FROM tbl_empleados WHERE id_empleado = ?";
// $stmt = $conexion->prepare($query);
// $stmt->bind_param("i", $usuarioID);
// $stmt->execute();
// $result = $stmt->get_result();
// $empleado = $result->fetch_assoc();

// if (!$empleado) {
//     respuestaJSON("error", "El empleado no existe.");
// }

// $nombreEmpleado = preg_replace("/[^a-zA-Z0-9]/", "_", $empleado['nombre_emp']); // Sanitiza nombre
// $uploadDirNuevo = 'uploads/' . $fechaPagoNueva . '/';

// // Crear carpeta si no existe
// if (!is_dir($uploadDirNuevo)) {
//     mkdir($uploadDirNuevo, 0777, true);
// }

// // Manejo del archivo
// try {
//     $conexion->begin_transaction(); // Iniciar transacción

//     if ($nuevoArchivo && $nuevoArchivo['error'] === UPLOAD_ERR_OK) {
//         // Validaciones del nuevo archivo
//         $maxFileSize = 5 * 1024 * 1024; // 5MB
//         $fileTmpPath = $nuevoArchivo['tmp_name'];
//         $fileName = $nuevoArchivo['name'];
//         $fileSize = $nuevoArchivo['size'];

//         $mimeType = mime_content_type($fileTmpPath);
//         if (!in_array($mimeType, ['application/pdf', 'text/xml'])) {
//             respuestaJSON("error", "Solo se permiten archivos PDF o XML.");
//         }

//         if ($fileSize > $maxFileSize) {
//             respuestaJSON("error", "El archivo excede el tamaño máximo permitido (5MB).");
//         }

//         // Generar nuevo nombre único
//         $timestamp = time();
//         $newFileName = $nombreEmpleado . "_" . str_replace("-", "", $fechaPagoNueva) . "_$timestamp." . pathinfo($fileName, PATHINFO_EXTENSION);
//         $newFilePath = $uploadDirNuevo . $newFileName;

//         // Eliminar el archivo anterior si existe
//         if (file_exists($archivoActual['ruta_archivo'])) {
//             unlink($archivoActual['ruta_archivo']);
//         }

//         // Mover el nuevo archivo
//         if (!move_uploaded_file($fileTmpPath, $newFilePath)) {
//             throw new Exception("Error al mover el nuevo archivo.");
//         }

//         // Actualizar en la BD
//         $updateFields[] = "nombre_archivo = ?, ruta_archivo = ?";
//         $params[] = $newFileName;
//         $params[] = $newFilePath;
//         $types .= "ss";
//     } elseif ($moverArchivo) {
//         // Si solo cambia la fecha, mover el archivo a la nueva ubicación
//         $oldFilePath = $archivoActual['ruta_archivo'];
//         $newFileName = basename($oldFilePath);
//         $newFilePath = $uploadDirNuevo . $newFileName;

//         if (!rename($oldFilePath, $newFilePath)) {
//             throw new Exception("Error al mover el archivo a la nueva carpeta.");
//         }

//         // Actualizar en la BD
//         $updateFields[] = "ruta_archivo = ?";
//         $params[] = $newFilePath;
//         $types .= "s";
//     }

//     // Si se actualizó la fecha
//     if (!empty($fechaPago)) {
//         $updateFields[] = "fechaPago = ?";
//         $params[] = $fechaPago;
//         $types .= "s";
//     }

//     // Verificar si hay datos para actualizar
//     if (empty($updateFields)) {
//         respuestaJSON("error", "No se enviaron cambios para actualizar.");
//     }

//     // Agregar el WHERE
//     $updateFields[] = "fecha_subida = NOW()"; // Agregar fecha de actualización
//     $updateSQL = "UPDATE tbl_archivos SET " . implode(", ", $updateFields) . " WHERE id_archivo = ?";
//     $params[] = $idArchivo;
//     $types .= "i";

//     // Preparar y ejecutar el SQL
//     $stmt = $conexion->prepare($updateSQL);
//     $stmt->bind_param($types, ...$params);

//     if ($stmt->execute()) {
//         $conexion->commit();
//         respuestaJSON("success", "Archivo actualizado con éxito.", ["ruta" => $newFilePath ?? $archivoActual['ruta_archivo']]);
//     } else {
//         $conexion->rollback();
//         respuestaJSON("error", "Error al actualizar los datos.");
//     }
// } catch (Exception $e) {
//     $conexion->rollback();
//     respuestaJSON("error", $e->getMessage());
// }

// // Función para enviar respuestas JSON
// function respuestaJSON($status, $message, $data = [])
// {
//     echo json_encode(array_merge(["status" => $status, "message" => $message], $data));
//     exit;
// }



// require '../../config/config.php'; // Conexión a MySQLi

// // Verifica que la solicitud sea POST
// if ($_SERVER["REQUEST_METHOD"] !== "POST") {
//     respuestaJSON("error", "Método no permitido.");
// }

// // Recibe los datos del formulario
// $idArchivo  = $_POST['idArchivo'] ?? null;
// $usuarioID  = $_POST['usuarioID'] ?? null;
// $fechaPago  = $_POST['fechaPago'] ?? null;
// $nuevoArchivo = $_FILES['nuevoArchivo'] ?? null;

// // Validación inicial
// if (!$idArchivo || !$usuarioID) {
//     respuestaJSON("error", "Faltan datos obligatorios.");
// }

// // Consulta la información actual del archivo
// $query = "SELECT id_empleado, nombre_archivo, ruta_archivo, fechaPago FROM tbl_archivos WHERE id_archivo = ?";
// $stmt = $conexion->prepare($query);
// $stmt->bind_param("i", $idArchivo);
// $stmt->execute();
// $result = $stmt->get_result();
// $archivoActual = $result->fetch_assoc();

// if (!$archivoActual) {
//     respuestaJSON("error", "El archivo no existe.");
// }

// // Verificar permisos
// if ($archivoActual['id_empleado'] != $usuarioID) {
//     respuestaJSON("error", "No tienes permisos para modificar este archivo.");
// }

// // Construcción del SQL dinámico
// $updateFields = [];
// $params = [];
// $types = "";

// // Formatear fechaPago
// $fechaPagoNueva = !empty($fechaPago) ? date('Y/m/d', strtotime($fechaPago)) : $archivoActual['fechaPago'];
// $fechaPagoAntigua = date('Y-m-d', strtotime($archivoActual['fechaPago']));
// $moverArchivo = ($fechaPagoNueva !== $fechaPagoAntigua);

// // Obtener nombre del empleado
// $query = "SELECT nombre_emp FROM tbl_empleados WHERE id_empleado = ?";
// $stmt = $conexion->prepare($query);
// $stmt->bind_param("i", $usuarioID);
// $stmt->execute();
// $result = $stmt->get_result();
// $empleado = $result->fetch_assoc();

// if (!$empleado) {
//     respuestaJSON("error", "El empleado no existe.");
// }

// $nombreEmpleado = preg_replace("/[^a-zA-Z0-9]/", "_", $empleado['nombre_emp']);
// $uploadDirNuevo = 'uploads/' . $fechaPagoNueva . '/';

// // Crear carpeta si no existe
// if (!is_dir($uploadDirNuevo)) {
//     mkdir($uploadDirNuevo, 0777, true);
// }

// try {
//     $conexion->begin_transaction();

//     if ($nuevoArchivo && $nuevoArchivo['error'] === UPLOAD_ERR_OK) {
//         // Validaciones del nuevo archivo
//         $maxFileSize = 5 * 1024 * 1024; // 5MB
//         $fileTmpPath = $nuevoArchivo['tmp_name'];
//         $fileName = $nuevoArchivo['name'];
//         $fileSize = $nuevoArchivo['size'];

//         if ($fileSize > $maxFileSize) {
//             respuestaJSON("error", "El archivo excede 5MB.");
//         }

//         $extension = pathinfo($fileName, PATHINFO_EXTENSION);
//         $newFileName = "{$nombreEmpleado}_{$fechaPagoNueva}.{$extension}";
//         $newFilePath = $uploadDirNuevo . $newFileName;

//         // Eliminar archivo anterior
//         if (file_exists($archivoActual['ruta_archivo'])) {
//             unlink($archivoActual['ruta_archivo']);
//         }

//         // Mover el nuevo archivo
//         if (!move_uploaded_file($fileTmpPath, $newFilePath)) {
//             throw new Exception("Error al mover el archivo.");
//         }

//         $updateFields[] = "nombre_archivo = ?, ruta_archivo = ?";
//         $params[] = $newFileName;
//         $params[] = $newFilePath;
//         $types .= "ss";
//     } elseif ($moverArchivo) {
//         // Mover archivo si solo cambia la fecha
//         $oldFilePath = $archivoActual['ruta_archivo'];
//         $newFileName = basename($oldFilePath);
//         $newFilePath = $uploadDirNuevo . $newFileName;

//         if (!rename($oldFilePath, $newFilePath)) {
//             throw new Exception("Error al mover el archivo.");
//         }

//         $updateFields[] = "ruta_archivo = ?";
//         $params[] = $newFilePath;
//         $types .= "s";
//     }

//     // Si se actualiza la fecha
//     if (!empty($fechaPago)) {
//         $updateFields[] = "fechaPago = ?";
//         $params[] = $fechaPagoNueva;
//         $types .= "s";
//     }

//     if (empty($updateFields)) {
//         respuestaJSON("error", "No se enviaron cambios.");
//     }

//     $updateSQL = "UPDATE tbl_archivos SET " . implode(", ", $updateFields) . " WHERE id_archivo = ?";
//     $params[] = $idArchivo;
//     $types .= "i";

//     $stmt = $conexion->prepare($updateSQL);
//     $stmt->bind_param($types, ...$params);

//     if ($stmt->execute()) {
//         $conexion->commit();
//         // Eliminar carpetas vacías
//         $oldDir = dirname($archivoActual['ruta_archivo']);
//         if (is_dir($oldDir) && count(scandir($oldDir)) == 2) {
//             rmdir($oldDir);
//         }
//         respuestaJSON("success", "Archivo actualizado.", ["ruta" => $newFilePath ?? $archivoActual['ruta_archivo']]);
//     } else {
//         $conexion->rollback();
//         respuestaJSON("error", "Error en la actualización.");
//     }
// } catch (Exception $e) {
//     $conexion->rollback();
//     respuestaJSON("error", $e->getMessage());
// }

// function respuestaJSON($status, $message, $data = [])
// {
//     echo json_encode(array_merge(["status" => $status, "message" => $message], $data));
//     exit;
// }










//////////////////////////////////


// require '../../config/config.php'; // Conexión a MySQLi

// // Verifica que la solicitud sea POST
// if ($_SERVER["REQUEST_METHOD"] !== "POST") {
//     respuestaJSON("error", "Método no permitido.");
// }

// // Recibe los datos del formulario
// $idArchivo  = $_POST['idArchivo'] ?? null;
// $usuarioID  = $_POST['usuarioID'] ?? null;
// $fechaPago  = $_POST['fechaPago'] ?? null;
// $nuevoArchivo = $_FILES['nuevoArchivo'] ?? null;

// // Validación inicial
// if (!$idArchivo || !$usuarioID) {
//     respuestaJSON("error", "Faltan datos obligatorios.");
// }

// // Consulta la información actual del archivo
// $query = "SELECT id_empleado, nombre_archivo, ruta_archivo, fechaPago FROM tbl_archivos WHERE id_archivo = ?";
// $stmt = $conexion->prepare($query);
// $stmt->bind_param("i", $idArchivo);
// $stmt->execute();
// $result = $stmt->get_result();
// $archivoActual = $result->fetch_assoc();

// if (!$archivoActual) {
//     respuestaJSON("error", "El archivo no existe.");
// }

// // Verificar permisos
// if ($archivoActual['id_empleado'] != $usuarioID) {
//     respuestaJSON("error", "No tienes permisos para modificar este archivo.");
// }

// // Construcción del SQL dinámico
// $updateFields = [];
// $params = [];
// $types = "";

// // Formatear fechaPago
// $fechaPagoNueva = !empty($fechaPago) ? date('Y/m/d', strtotime($fechaPago)) : $archivoActual['fechaPago'];
// $fechaPagoAntigua = date('Y-m-d', strtotime($archivoActual['fechaPago']));
// $moverArchivo = ($fechaPagoNueva !== $fechaPagoAntigua);

// // Obtener nombre del empleado
// $query = "SELECT nombre_emp FROM tbl_empleados WHERE id_empleado = ?";
// $stmt = $conexion->prepare($query);
// $stmt->bind_param("i", $usuarioID);
// $stmt->execute();
// $result = $stmt->get_result();
// $empleado = $result->fetch_assoc();

// if (!$empleado) {
//     respuestaJSON("error", "El empleado no existe.");
// }

// $nombreEmpleado = preg_replace("/[^a-zA-Z0-9]/", "_", $empleado['nombre_emp']);
// $uploadDirNuevo = 'uploads/' . $fechaPagoNueva . '/';

// // Crear carpeta si no existe
// if (!is_dir($uploadDirNuevo)) {
//     mkdir($uploadDirNuevo, 0777, true);
// }

// try {
//     $conexion->begin_transaction();

//     if ($nuevoArchivo && $nuevoArchivo['error'] === UPLOAD_ERR_OK) {
//         // Validaciones del nuevo archivo
//         $maxFileSize = 5 * 1024 * 1024; // 5MB
//         $fileTmpPath = $nuevoArchivo['tmp_name'];
//         $fileName = $nuevoArchivo['name'];
//         $fileSize = $nuevoArchivo['size'];

//         if ($fileSize > $maxFileSize) {
//             respuestaJSON("error", "El archivo excede 5MB.");
//         }

//         $extension = pathinfo($fileName, PATHINFO_EXTENSION);
//         $newFileName = "{$nombreEmpleado}_{$fechaPagoNueva}.{$extension}";
//         $newFilePath = $uploadDirNuevo . $newFileName;

//         // Eliminar archivo anterior
//         if (file_exists($archivoActual['ruta_archivo'])) {
//             unlink($archivoActual['ruta_archivo']);
//         }

//         // Mover el nuevo archivo
//         if (!move_uploaded_file($fileTmpPath, $newFilePath)) {
//             throw new Exception("Error al mover el archivo.");
//         }

//         $updateFields[] = "nombre_archivo = ?, ruta_archivo = ?";
//         $params[] = $newFileName;
//         $params[] = $newFilePath;
//         $types .= "ss";
//     } elseif ($moverArchivo) {
//         // Mover archivo si solo cambia la fecha
//         $oldFilePath = $archivoActual['ruta_archivo'];
//         $newFileName = basename($oldFilePath);
//         $newFilePath = $uploadDirNuevo . $newFileName;

//         if (!rename($oldFilePath, $newFilePath)) {
//             throw new Exception("Error al mover el archivo.");
//         }

//         $updateFields[] = "ruta_archivo = ?";
//         $params[] = $newFilePath;
//         $types .= "s";
//     }

//     // Si se actualiza la fecha
//     if (!empty($fechaPago)) {
//         $updateFields[] = "fechaPago = ?";
//         $params[] = $fechaPagoNueva;
//         $types .= "s";
//     }

//     if (empty($updateFields)) {
//         respuestaJSON("error", "No se enviaron cambios.");
//     }

//     $updateSQL = "UPDATE tbl_archivos SET " . implode(", ", $updateFields) . " WHERE id_archivo = ?";
//     $params[] = $idArchivo;
//     $types .= "i";

//     $stmt = $conexion->prepare($updateSQL);
//     $stmt->bind_param($types, ...$params);

//     if ($stmt->execute()) {
//         $conexion->commit();
//         // Eliminar carpetas vacías
//         $oldDir = dirname($archivoActual['ruta_archivo']);
//         if (is_dir($oldDir) && count(scandir($oldDir)) == 2) {
//             rmdir($oldDir);
//         }
//         respuestaJSON("success", "Archivo actualizado.", ["ruta" => $newFilePath ?? $archivoActual['ruta_archivo']]);
//     } else {
//         $conexion->rollback();
//         respuestaJSON("error", "Error en la actualización.");
//     }
// } catch (Exception $e) {
//     $conexion->rollback();
//     respuestaJSON("error", $e->getMessage());
// }

// function respuestaJSON($status, $message, $data = [])
// {
//     echo json_encode(array_merge(["status" => $status, "message" => $message], $data));
//     exit;
// }




// require '../../config/config.php'; // Conexión a MySQLi

// // Verifica que la solicitud sea POST
// if ($_SERVER["REQUEST_METHOD"] !== "POST") {
//     respuestaJSON("error", "Método no permitido.");
// }

// // Recibe los datos del formulario
// $idArchivo  = $_POST['idArchivo'] ?? null;
// $usuarioID  = $_POST['usuarioID'] ?? null;
// $fechaPago  = $_POST['fechaPago'] ?? null;
// $nuevoArchivo = $_FILES['nuevoArchivo'] ?? null;

// // Validación inicial
// if (!$idArchivo || !$usuarioID) {
//     respuestaJSON("error", "Faltan datos obligatorios.");
// }

// // Consulta la información actual del archivo
// $query = "SELECT id_empleado, nombre_archivo, ruta_archivo, fechaPago FROM tbl_archivos WHERE id_archivo = ?";
// $stmt = $conexion->prepare($query);
// $stmt->bind_param("i", $idArchivo);
// $stmt->execute();
// $result = $stmt->get_result();
// $archivoActual = $result->fetch_assoc();

// if (!$archivoActual) {
//     respuestaJSON("error", "El archivo no existe.");
// }

// // Verificar permisos
// if ($archivoActual['id_empleado'] != $usuarioID) {
//     respuestaJSON("error", "No tienes permisos para modificar este archivo.");
// }

// // Construcción del SQL dinámico
// $updateFields = [];
// $params = [];
// $types = "";

// // Formatear fechaPago
// $fechaPagoNueva = !empty($fechaPago) ? date('Y-m-d', strtotime($fechaPago)) : $archivoActual['fechaPago'];
// $fechaPagoAntigua = date('Y-m-d', strtotime($archivoActual['fechaPago']));
// $moverArchivo = ($fechaPagoNueva !== $fechaPagoAntigua);

// // Obtener nombre del empleado
// $query = "SELECT nombre_emp FROM tbl_empleados WHERE id_empleado = ?";
// $stmt = $conexion->prepare($query);
// $stmt->bind_param("i", $usuarioID);
// $stmt->execute();
// $result = $stmt->get_result();
// $empleado = $result->fetch_assoc();

// if (!$empleado) {
//     respuestaJSON("error", "El empleado no existe.");
// }

// $nombreEmpleado = preg_replace("/[^a-zA-Z0-9]/", "_", $empleado['nombre_emp']);
// $uploadDirNuevo = 'uploads/' . $fechaPagoNueva . '/';

// // Crear carpeta si no existe
// if (!is_dir($uploadDirNuevo)) {
//     mkdir($uploadDirNuevo, 0777, true);
// }

// try {
//     $conexion->begin_transaction();

//     if ($nuevoArchivo && $nuevoArchivo['error'] === UPLOAD_ERR_OK) {
//         // Validaciones del nuevo archivo
//         $maxFileSize = 5 * 1024 * 1024; // 5MB
//         $fileTmpPath = $nuevoArchivo['tmp_name'];
//         $fileName = $nuevoArchivo['name'];
//         $fileSize = $nuevoArchivo['size'];

//         if ($fileSize > $maxFileSize) {
//             respuestaJSON("error", "El archivo excede 5MB.");
//         }

//         $extension = pathinfo($fileName, PATHINFO_EXTENSION);
//         $newFileName = "{$nombreEmpleado}_{$fechaPagoNueva}.{$extension}";
//         $newFilePath = $uploadDirNuevo . $newFileName;

//         // Eliminar archivo anterior
//         if (file_exists($archivoActual['ruta_archivo'])) {
//             unlink($archivoActual['ruta_archivo']);
//         }

//         // Mover el nuevo archivo
//         if (!move_uploaded_file($fileTmpPath, $newFilePath)) {
//             throw new Exception("Error al mover el archivo.");
//         }

//         $updateFields[] = "nombre_archivo = ?, ruta_archivo = ?";
//         $params[] = $newFileName;
//         $params[] = $newFilePath;
//         $types .= "ss";
//     } elseif ($moverArchivo) {
//         // Mover archivo si solo cambia la fecha
//         $oldFilePath = $archivoActual['ruta_archivo'];
//         $newFileName = basename($oldFilePath);
//         $newFilePath = $uploadDirNuevo . $newFileName;

//         if (!rename($oldFilePath, $newFilePath)) {
//             throw new Exception("Error al mover el archivo.");
//         }

//         $updateFields[] = "ruta_archivo = ?";
//         $params[] = $newFilePath;
//         $types .= "s";
//     }

//     // Si se actualiza la fecha
//     if (!empty($fechaPago)) {
//         $updateFields[] = "fechaPago = ?";
//         $params[] = $fechaPagoNueva;
//         $types .= "s";
//     }

//     if (empty($updateFields)) {
//         respuestaJSON("error", "No se enviaron cambios.");
//     }

//     $updateSQL = "UPDATE tbl_archivos SET " . implode(", ", $updateFields) . " WHERE id_archivo = ?";
//     $params[] = $idArchivo;
//     $types .= "i";

//     $stmt = $conexion->prepare($updateSQL);
//     $stmt->bind_param($types, ...$params);

//     if ($stmt->execute()) {
//         $conexion->commit();
//         // Eliminar carpetas vacías de forma segura
//         $oldDir = dirname($archivoActual['ruta_archivo']);
//         if (is_dir($oldDir) && is_writable($oldDir)) {
//             $files = array_diff(scandir($oldDir), ['.', '..']);
//             if (empty($files)) {
//                 rmdir($oldDir);
//             }
//         }
//         respuestaJSON("success", "Archivo actualizado.", ["ruta" => $newFilePath ?? $archivoActual['ruta_archivo']]);
//     } else {
//         $conexion->rollback();
//         respuestaJSON("error", "Error en la actualización.");
//     }
// } catch (Exception $e) {
//     $conexion->rollback();
//     respuestaJSON("error", $e->getMessage());
// }

// function respuestaJSON($status, $message, $data = [])
// {
//     echo json_encode(array_merge(["status" => $status, "message" => $message], $data));
//     exit;
// }



require '../../config/config.php'; // Conexión a MySQLi

if ($_SERVER["REQUEST_METHOD"] !== "POST") {
    respuestaJSON("error", "Método no permitido.");
}

$idArchivo  = $_POST['idArchivo'] ?? null;
$usuarioID  = $_POST['usuarioID'] ?? null;
$fechaPago  = $_POST['fechaPago'] ?? null;
$nuevoArchivo = $_FILES['nuevoArchivo'] ?? null;

if (!$idArchivo || !$usuarioID) {
    respuestaJSON("error", "Faltan datos obligatorios.");
}

$query = "SELECT id_empleado, nombre_archivo, ruta_archivo, fechaPago FROM tbl_archivos WHERE id_archivo = ?";
$stmt = $conexion->prepare($query);
$stmt->bind_param("i", $idArchivo);
$stmt->execute();
$result = $stmt->get_result();
$archivoActual = $result->fetch_assoc();

if (!$archivoActual) {
    respuestaJSON("error", "El archivo no existe.");
}

if ($archivoActual['id_empleado'] != $usuarioID) {
    respuestaJSON("error", "No tienes permisos para modificar este archivo.");
}

$updateFields = [];
$params = [];
$types = "";

$fechaPagoNueva = !empty($fechaPago) ? date('Y-m-d', strtotime($fechaPago)) : $archivoActual['fechaPago'];
$fechaPagoAntigua = date('Y-m-d', strtotime($archivoActual['fechaPago']));
$moverArchivo = ($fechaPagoNueva !== $fechaPagoAntigua);

$query = "SELECT user_rfc  FROM tbl_empleados WHERE id_empleado = ?";
$stmt = $conexion->prepare($query);
$stmt->bind_param("i", $usuarioID);
$stmt->execute();
$result = $stmt->get_result();
$empleado = $result->fetch_assoc();

if (!$empleado) {
    respuestaJSON("error", "El empleado no existe.");
}

// $rfcuser = preg_replace("/[^a-zA-Z0-9]/", "_", $empleado['user_rfc ']);
$rfcuser = $empleado['user_rfc'];


// Extraer Año, Mes, Día de la fecha de pago
list($year, $month, $day) = explode('-', $fechaPagoNueva);
$uploadDirNuevo = "uploads/{$year}/{$month}/{$day}/";

// Crear carpeta si no existe
if (!is_dir($uploadDirNuevo)) {
    mkdir($uploadDirNuevo, 0777, true);
}

try {
    $conexion->begin_transaction();

    if ($nuevoArchivo && $nuevoArchivo['error'] === UPLOAD_ERR_OK) {
        $maxFileSize = 5 * 1024 * 1024; // 5MB
        $fileTmpPath = $nuevoArchivo['tmp_name'];
        $fileName = $nuevoArchivo['name'];
        $fileSize = $nuevoArchivo['size'];

        if ($fileSize > $maxFileSize) {
            respuestaJSON("error", "El archivo excede 5MB.");
        }

        $extension = pathinfo($fileName, PATHINFO_EXTENSION);
        // $newFileName = "{$nombreEmpleado}_{$fechaPagoNueva}.{$extension}";
        // $newFileName = "{$rfcuser}_{$fechaPagoNueva}_" . time() . ".{$extension}";

        $timestamp = time();
        $newFileName = "{$rfcuser}_" . str_replace("-", "", $fechaPagoNueva) . "_{$timestamp}.{$extension}";

        $newFilePath = $uploadDirNuevo . $newFileName;

        if (file_exists($archivoActual['ruta_archivo'])) {
            unlink($archivoActual['ruta_archivo']);
        }

        if (!move_uploaded_file($fileTmpPath, $newFilePath)) {
            throw new Exception("Error al mover el archivo.");
        }

        $updateFields[] = "nombre_archivo = ?, ruta_archivo = ?";
        $params[] = $newFileName;
        $params[] = $newFilePath;
        $types .= "ss";
        // } elseif ($moverArchivo) {
        //     $oldFilePath = $archivoActual['ruta_archivo'];
        //     $newFileName = basename($oldFilePath);
        //     $newFilePath = $uploadDirNuevo . $newFileName;

        //     if (!rename($oldFilePath, $newFilePath)) {
        //         throw new Exception("Error al mover el archivo.");
        //     }

        //     $updateFields[] = "ruta_archivo = ?";
        //     $params[] = $newFilePath;
        //     $types .= "s";
        // }
    } elseif ($moverArchivo) {
        $oldFilePath = $archivoActual['ruta_archivo'];
        $oldFileName = basename($oldFilePath);

        // Extraer la extensión del archivo original
        $extension = pathinfo($oldFileName, PATHINFO_EXTENSION);

        // Generar nuevo nombre basado en la nueva fecha de pago
        $timestamp = time();
        $newFileName = "{$rfcuser}_" . str_replace("-", "", $fechaPagoNueva) . "_{$timestamp}.{$extension}";
        $newFilePath = $uploadDirNuevo . $newFileName;

        if (!rename($oldFilePath, $newFilePath)) {
            throw new Exception("Error al mover y renombrar el archivo.");
        }

        $updateFields[] = "nombre_archivo = ?, ruta_archivo = ?";
        $params[] = $newFileName;
        $params[] = $newFilePath;
        $types .= "ss";
    }


    if (!empty($fechaPago)) {
        $updateFields[] = "fechaPago = ?";
        $params[] = $fechaPagoNueva;
        $types .= "s";
    }

    if (empty($updateFields)) {
        respuestaJSON("error", "No se enviaron cambios.");
    }

    $updateSQL = "UPDATE tbl_archivos SET " . implode(", ", $updateFields) . " WHERE id_archivo = ?";
    $params[] = $idArchivo;
    $types .= "i";

    $stmt = $conexion->prepare($updateSQL);
    $stmt->bind_param($types, ...$params);

    if ($stmt->execute()) {
        $conexion->commit();

        // Eliminar carpetas vacías
        $oldDir = dirname($archivoActual['ruta_archivo']);
        while (is_dir($oldDir) && is_writable($oldDir)) {
            $files = array_diff(scandir($oldDir), ['.', '..']);
            if (empty($files)) {
                rmdir($oldDir);
                $oldDir = dirname($oldDir); // Subir un nivel
            } else {
                break;
            }
        }

        respuestaJSON("success", "Archivo actualizado.", ["ruta" => $newFilePath ?? $archivoActual['ruta_archivo']]);
    } else {
        $conexion->rollback();
        respuestaJSON("error", "Error en la actualización.");
    }
} catch (Exception $e) {
    $conexion->rollback();
    respuestaJSON("error", $e->getMessage());
}

function respuestaJSON($status, $message, $data = [])
{
    echo json_encode(array_merge(["status" => $status, "message" => $message], $data));
    exit;
}