<?php

require '../../config/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Obtener datos enviados
    $id_documento = $_POST['update_id_document'] ?? null;
    $id_empleado = $_POST['update_id_usuario'] ?? null;


    // Validar datos obligatorios
    if (!$id_documento || !$id_empleado) {
        echo json_encode(["status" => "error", "message" => "Faltan datos obligatorios."]);
        exit;
    }

    // Directorio de almacenamiento
    $directorio = "../../uploads/docs_usuarios/usuario_$id_empleado/";

    // Verificar y crear directorio si no existe
    if (!is_dir($directorio) && !mkdir($directorio, 0755, true)) {
        echo json_encode(["status" => "error", "message" => "No se pudo crear el directorio de almacenamiento."]);
        exit;
    }

    // Tipos de archivos permitidos
    $archivos = ['contrato', 'afiliacion', 'baja'];
    $campos_a_actualizar = [];
    $valores_a_bindear = [];
    $tipos = ""; // Para mysqli_bind_param
    $errores = [];

    foreach ($archivos as $archivo) {
        if (isset($_FILES[$archivo]) && $_FILES[$archivo]['error'] === UPLOAD_ERR_OK) {
            $nombreArchivo = basename($_FILES[$archivo]['name']);
            $tipoArchivo = strtolower(pathinfo($nombreArchivo, PATHINFO_EXTENSION));

            // Validar que el archivo sea un PDF
            if ($tipoArchivo !== 'pdf') {
                $errores[] = "El archivo $archivo debe ser un PDF.";
                continue;
            }

            // Ruta de almacenamiento del archivo
            $rutaArchivo = $directorio . $id_empleado . "_" . $archivo . time() . ".pdf";

            // Mover archivo
            if (move_uploaded_file($_FILES[$archivo]['tmp_name'], $rutaArchivo)) {
                $campos_a_actualizar[] = "$archivo = ?";
                $valores_a_bindear[] = $rutaArchivo;
                $tipos .= "s";
            } else {
                $errores[] = "Error al subir el archivo $archivo.";
            }
        }
    }

    // Si hay archivos para actualizar
    if (!empty($campos_a_actualizar)) {
        $query = "UPDATE tbl_doc_empl SET " . implode(", ", $campos_a_actualizar) . " WHERE id = ?";
        $stmt = $conexion->prepare($query);

        if (!$stmt) {
            echo json_encode(["status" => "error", "message" => "Error en la consulta SQL: " . $conexion->error]);
            exit;
        }

        // Agregar `id_documento` al final para el `WHERE`
        $valores_a_bindear[] = $id_documento;
        $tipos .= "i"; // `i` para el `id_documento`

        // Bind de parámetros dinámico
        $stmt->bind_param($tipos, ...$valores_a_bindear);

        // Ejecutar consulta
        if ($stmt->execute()) {
            $status = empty($errores) ? "success" : "warning";
            $message = empty($errores) ? "Documentos actualizados con éxito." : implode(' ', $errores);
        } else {
            $status = "error";
            $message = "Error al actualizar en la base de datos: " . $stmt->error;
        }

        $stmt->close();
        $conexion->close();

        echo json_encode(["status" => $status, "message" => $message]);
        exit;
    }

    // Si no se subió ningún archivo
    echo json_encode(["status" => "error", "message" => "No se subió ningún archivo para actualizar."]);

    exit;
}
