<?php


session_start();
header('Content-Type: application/json'); // Asegurar que la respuesta sea JSON

require '../../config/config.php'; // Conexión a la BD

// Función para validar RFC
function validarRFC($rfc)
{
    $pattern = "/^([A-ZÑ&]{3,4})\\d{6}([A-Z0-9]{3})?$/";
    return preg_match($pattern, strtoupper($rfc));
}

// Función para validar email
function validarEmail($email)
{
    return filter_var($email, FILTER_VALIDATE_EMAIL);
}

// Función para enviar respuestas JSON
function enviarRespuesta($status, $message, $data = [])
{
    echo json_encode([
        'status' => $status,
        'message' => $message,
        'data' => $data,
    ]);
    exit;
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    try {
        // Obtener datos del formulario
        $id_usu = $_POST['usuarioIDupdate'];
        $nombre_emp_update = $_POST['nombre_emp_update'] ?? '';
        $id_empleado_externo_update = $_POST['id_empleado_externo_update'] ?? '';
        $user_rfc_update = $_POST['user_rfc_update'] ?? '';
        $estadoupdate = $_POST['estadoupdate'] ?? '';
        $id_rol_update = $_POST['id_rol_update'] ?? '';
        $id_region_update = $_POST['id_region_update'] ?? '';
        $id_puesto_update = $_POST['id_puesto_update'] ?? '';
        $emailupdate = $_POST['emailupdate'] ?? '';
        $contraseña_usu = $_POST['contraseña_usu'] ?? '';
        $confirmar_contraseña_usu = $_POST['confirmar_contraseña_usu'] ?? '';
        $admin_contraseña = $_POST['admin_contraseña'] ?? '';

        // Validaciones básicas
        if (!empty($user_rfc_update) && !validarRFC($user_rfc_update)) {
            enviarRespuesta("error", "El RFC no tiene un formato válido.");
        }
        if (!empty($emailupdate) && !validarEmail($emailupdate)) {
            enviarRespuesta("error", "El email no tiene un formato válido.");
        }
        if (!empty($contraseña_usu) && strlen($contraseña_usu) < 8) {
            enviarRespuesta("error", "La contraseña debe tener al menos 8 caracteres.");
        }

        // // Validar contraseña solo si se intenta cambiar
        // $hashed_password = null;
        // if (!empty($contraseña_usu) && !empty($confirmar_contraseña_usu)) {
        //     if ($contraseña_usu !== $confirmar_contraseña_usu) {
        //         enviarRespuesta("error", "Las contraseñas no coinciden.");
        //     }

        //     // Verificar si el usuario es admin y su contraseña es correcta
        //     $admin_id = $_SESSION['id'];
        //     $query = "SELECT id_rol, password, user_rfc FROM tbl_empleados WHERE id_empleado = ?";
        //     $stmt = $conexion->prepare($query);
        //     $stmt->bind_param("i", $admin_id);
        //     $stmt->execute();
        //     $result = $stmt->get_result();
        //     $admin = $result->fetch_assoc();
        //     $id_rol_admin = (int) $admin['id_rol'];
        //     if ($id_rol_admin !== 1 ||  !password_verify($admin_contraseña, $admin['password'])) {
        //         enviarRespuesta("error", "No tienes permisos o la contraseña del administrador es incorrecta.");
        //     }

        //     $hashed_password = password_hash($contraseña_usu, PASSWORD_DEFAULT);
        // }

        // // Construcción dinámica de la consulta SQL
        // $camposActualizar = [];
        // $valores = [];

        // Validar contraseña solo si se intenta cambiar
        $hashed_password = null;
        if (!empty($contraseña_usu) && !empty($confirmar_contraseña_usu)) {
            if ($contraseña_usu !== $confirmar_contraseña_usu) {
                enviarRespuesta("error", "Las contraseñas no coinciden.");
            }

            // Obtener el ID del usuario autenticado
            $admin_id = $_SESSION['id'];

            // Consultar el rol y contraseña del usuario autenticado
            $query = "SELECT id_rol, password FROM tbl_empleados WHERE id_empleado = ?";
            $stmt = $conexion->prepare($query);
            $stmt->bind_param("i", $admin_id);
            $stmt->execute();
            $result = $stmt->get_result();
            $admin = $result->fetch_assoc();

            if (!$admin) {
                enviarRespuesta("error", "Error al obtener los datos del usuario.");
            }

            $id_rol_admin = (int) $admin['id_rol'];

            // Verificar que el usuario sea Admin (1) o POA (3) y que su contraseña sea correcta
            if (!in_array($id_rol_admin, [1, 3]) || !password_verify($admin_contraseña, $admin['password'])) {
                enviarRespuesta("error", "No tienes permisos o la contraseña del administrador es incorrecta.");
            }

            // Encriptar la nueva contraseña
            $hashed_password = password_hash($contraseña_usu, PASSWORD_DEFAULT);
        }

        // Construcción dinámica de la consulta SQL
        $camposActualizar = [];
        $valores = [];

        if (!empty($id_empleado_externo_update)) {
            $camposActualizar[] = "id_empleado_externo = ?";
            $valores[] = $id_empleado_externo_update;
        }
        if (!empty($nombre_emp_update)) {
            $camposActualizar[] = "nombre_emp = ?";
            $valores[] = $nombre_emp_update;
        }
        if (!empty($user_rfc_update)) {
            $camposActualizar[] = "user_rfc = ?";
            $valores[] = $user_rfc_update;
        }
        if (!empty($estadoupdate)) {
            $camposActualizar[] = "estado = ?";
            $valores[] = $estadoupdate;
        }
        if (!empty($id_rol_update)) {
            $camposActualizar[] = "id_rol = ?";
            $valores[] = $id_rol_update;
        }
        if (!empty($id_region_update)) {
            $camposActualizar[] = "id_region = ?";
            $valores[] = $id_region_update;
        }
        if (!empty($id_puesto_update)) {
            $camposActualizar[] = "id_puesto = ?";
            $valores[] = $id_puesto_update;
        }
        if (!empty($emailupdate)) {
            $camposActualizar[] = "email = ?";
            $valores[] = $emailupdate;
        }
        if ($hashed_password !== null) {
            $camposActualizar[] = "password = ?";
            $valores[] = $hashed_password;
        }

        if (empty($camposActualizar)) {
            enviarRespuesta("error", "No se enviaron datos para actualizar.");
        }

        // Generar la consulta SQL dinámica
        $query = "UPDATE tbl_empleados SET " . implode(", ", $camposActualizar) . " WHERE id_empleado = ?";
        $valores[] = $id_usu;
        $tipos = str_repeat("s", count($valores) - 1) . "i";

        $stmt = $conexion->prepare($query);
        if (!$stmt) {
            enviarRespuesta("error", "Error en la preparación de la consulta.");
        }

        // Vincular parámetros de manera dinámica
        $stmt->bind_param($tipos, ...$valores);

        // Ejecutar la consulta
        if ($stmt->execute()) {
            enviarRespuesta("success", "Información de empleado actualizada correctamente.");
        } else {
            enviarRespuesta("error", "Error al actualizar la información del empleado.");
        }
    } catch (Exception $e) {
        enviarRespuesta("error", "Error interno: " . $e->getMessage());
    }
}